(ns degree9.remote
  "Provides methods for connecting via microservices pattern."
  (:require
    [meta.server :as server]
    [meta.client :as client]))

(defn connection
  "Create a connection to a remote server."
  [uri]
  (-> (client/app)
    (client/with-socketio uri)
    (client/with-authentication nil)))

(defn api
  "Mount a remote service to a local endpoint."
  [app path uri service hooks]
  (server/api app path (client/service (connection uri) service) hooks))

(defn service
  "Create a service which will proxy requests to a remote service."
  [service & [opts]]
  (let [uri {:uri opts}]
    (reify
      Object
      (id [this] "id")
      (setup [this app path]
        (goog.object/set this "remote" (connection uri)))
      (find [this params]
        (client/find (client/service (goog.object/get this "remote") service) params))
      (get [this id params]
        (client/get (client/service (goog.object/get this "remote") service) params))
      (create [this data params]
        (client/create (client/service (goog.object/get this "remote") service) params))
      (update [this id data params]
        (client/update (client/service (goog.object/get this "remote") service) params))
      (patch [this id data params]
        (client/patch (client/service (goog.object/get this "remote") service) params))
      (remove [this id params]
        (client/remove (client/service (goog.object/get this "remote") service) params)))))
