(ns degree9.remote
  "Provides methods for connecting via microservices pattern."
  (:require
    [meta.server :as server]
    [meta.client :as client]))

(defn connection
  "Create a connection to a remote server."
  [uri]
  (-> (client/app)
    (client/with-socketio uri)
    (client/with-authentication nil)))

(defn service
  "Create a service which will proxy requests to a remote service."
  [service & [opts]]
  (let [uri {:uri opts}]
    (reify
      Object
      (id [this] "id")
      (setup [this app path]
        (goog.object/set this "remote"
          (client/service (connection uri) service)))
      (find [this params]
        (client/find (goog.object/get this "remote") params))
      (get [this id params]
        (client/get (goog.object/get this "remote") params))
      (create [this data params]
        (client/create (goog.object/get this "remote") params))
      (update [this id data params]
        (client/update (goog.object/get this "remote") params))
      (patch [this id data params]
        (client/patch (goog.object/get this "remote") params))
      (remove [this id params]
        (client/remove (goog.object/get this "remote") params)))))

(defn api
  "Mount a remote service to a local endpoint."
  [app path uri hooks]
  (server/api app path (service path {:uri uri} hooks)))
