(ns degree9.server
 (:require
   ["debug" :as dbg]
   [meta.server :as server]
   [degree9.env :as env]))

(def debug (dbg "degree9:enterprise:server"))

(defn app []
 (debug "Starting D9 enterprise server...")
 (-> (server/app)
     (server/with-defaults)
     (server/with-rest)
     (server/with-socketio)
     (server/with-authentication)))

(defn start! [app]
  (let [port (env/get "APP_PORT")]
    (debug "D9 server listening on %s" port)
    (server/listen app port)))
