(ns degree9.azure.service-bus
  (:require [degree9.azure :as azure]
            [degree9.env :as env]))

;; Azure Service Bus Low API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn service-bus
  ([] (service-bus (env/get "AZURE_SERVICEBUS_CONNECTION_STRING")))
  ([conn] (azure/service-bus conn)))

(defn create-queue
  ([sbus queue callback]
   (.createQueueIfNotExists sbus queue callback))
  ([sbus queue opts callback]
   (.createQueueIfNotExists sbus queue opts callback)))

(defn queue-send [sbus message callback]
  (.sendQueueMessage sbus message callback))

(defn queue-receive [sbus callback]
  (.receiveQueueMessage sbus callback))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
