(ns degree9.azure.service-bus
  (:require [degree9.azure :as azure]
            [degree9.env :as env]))

;; Azure Service Bus Low API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn service-bus
  ([] (service-bus (env/get "AZURE_SERVICEBUS_CONNECTION_STRING")))
  ([conn] (azure/service-bus conn)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Azure Service Bus Queues Low API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn create-queue
  ([sbus queue callback]
   (.createQueueIfNotExists sbus queue callback))
  ([sbus queue opts callback]
   (.createQueueIfNotExists sbus queue (clj->js opts) callback)))

(defn queue-send [sbus message callback]
  (.sendQueueMessage sbus message callback))

(defn queue-receive
  ([sbus callback]
   (.receiveQueueMessage sbus callback))
  ([sbus opts callback
    (.receiveQueueMessage sbus (clj->js opts) callback)]))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Azure Service Bus Topics Low API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn create-topic
  ([sbus queue callback]
   (.createTopicIfNotExists sbus queue callback))
  ([sbus queue opts callback]
   (.createTopicIfNotExists sbus queue (clj->js opts) callback)))

(defn create-subscription
  ([sbus queue callback]
   (.createTopicIfNotExists sbus queue callback))
  ([sbus queue opts callback]
   (.createTopicIfNotExists sbus queue (clj->js opts) callback)))

(defn topic-send [sbus message callback]
  (.sendQueueMessage sbus message callback))

(defn topic-receive
  ([sbus callback]
   (.receiveQueueMessage sbus callback))
  ([sbus opts callback
    (.receiveQueueMessage sbus (clj->js opts) callback)]))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
