(ns degree9.dummy
  "Provides a stub service that returns static JSON."
  (:require
    [degree9.debug :as dbg]
    [meta.server :as server]))

(dbg/defdebug debug "degree9:enterprise:dummy")

(defn Dummy [& [data]]
  (let []
    (reify
      Object
      (find   [this params]         data)
      (get    [this id params]      data)
      (create [this data params]    data)
      (update [this id data params] data)
      (patch  [this id data params] data)
      (remove [this id params]      data))))

(defn api
  "Mount a dummy service endpoint."
  [app path data hooks]
  (debug "Mount dummy service at %s" path)
  (server/api app path (Dummy data) hooks))
