(ns degree9.dummy
  "Provides a stub service that returns static JSON."
  (:require
    [degree9.debug :as dbg]
    [meta.server :as server]
    [meta.promise :as prom]))

(dbg/defdebug debug "degree9:enterprise:dummy")

(defn Dummy [& [data]]
  (let []
    (reify
      Object
      (find [this params]
        (prom/with-callback callback
          (callback nil data)))
      (get [this id params]
        (prom/with-callback callback
          (callback nil data)))
     (create [this data params]
        (prom/with-callback callback
          (callback nil data))
      (update [this id data params]
        (prom/with-callback callback
          (callback nil data)))
      (patch [this id data params]
        (prom/with-callback callback
          (callback nil data)))
      (remove [this id params]
        (prom/with-callback callback
          (callback nil data)))))))

(defn api
  "Mount a dummy service endpoint."
  [app path data hooks]
  (debug "Mount dummy service at %s" path)
  (server/api app path (Dummy data) hooks))
