(ns degree9.idle
  (:require [javelin.core :as j]))

(def ^:dynamic *away* (j/cell nil))

(def ^:dynamic *timeout* (j/cell 30000))

(def ^:dynamic *timestamp* (j/cell nil))

(j/cell= (prn "*timestamp*" *timestamp*))

(defn- detect-activity! [event]
  (reset! *timestamp* (.getTime (js/Date.))))

(defn idle! [& opts]
  (let [timeout (:timeout opts @*timeout*)
        active  (:active opts detect-activity!)]
    (.addEventListener js/window "click"      active)
    (.addEventListener js/window "mousemove"  active)
    (.addEventListener js/window "mouseenter" active)
    (.addEventListener js/window "keydown"    active)
    (.addEventListener js/window "scroll"     active)
    (.addEventListener js/window "mousewheel" active)
    (.addEventListener js/window "touchmove"  active)
    (.addEventListener js/window "touchstart" active)
    (.addEventListener js/window "keydown"    active)))
