(ns degree9.idle
  (:require [javelin.core :as j]))

(def ^:dynamic *last-active* (j/cell nil))

(def ^:dynamic *away* (j/cell nil))

(def ^:dynamic *timeout* (j/cell nil))

(j/cell= (prn "*timeout*" *timeout*))

(j/cell= (prn "*away*" *away*))

(j/cell= (prn "*last-active*" *last-active*))

(j/defc= idle? (or *away* ))

(defn- detect-activity! [event]
  (let [time (.getTime (js/Date.))]
    (reset! *last-active* time)
    (reset! *away* false)))

(defn idle! [timeout]
  (let []
    (.addEventListener js/window "click"      detect-activity!)
    (.addEventListener js/window "mousemove"  detect-activity!)
    (.addEventListener js/window "mouseenter" detect-activity!)
    (.addEventListener js/window "keydown"    detect-activity!)
    (.addEventListener js/window "scroll"     detect-activity!)
    (.addEventListener js/window "mousewheel" detect-activity!)
    (.addEventListener js/window "touchmove"  detect-activity!)
    (.addEventListener js/window "touchstart" detect-activity!)
    (.addEventListener js/window "keydown"    detect-activity!)
    (.addEventListener js/window "visibilitychange"       detect-activity!)
    (.addEventListener js/window "webkitvisibilitychange" detect-activity!)
    (.addEventListener js/window "msvisibilitychange"     detect-activity!)
    (js/setTimeout #(reset! *timeout* (.getTime (js/Date.))) timeout)))
