(ns degree9.auth.azureb2c
  (:require ["debug" :as dbg]
            [goog.object :as obj]
            [meta.server :as server]
            [degree9.env :as env]
            ["@feathersjs/authentication-oauth" :as oauth]))

(def ^:private debug (dbg "degree9:enterprise:auth:azureb2c"))

(defn with-azureb2c [app & opts]
  (let [auth   (.service app "/authentication")
        svc    (obj/get auth "OAuthStrategy")]
    (debug "Registering Azure B2C auth strategy.")
    (.register auth "azureb2c" (svc.))
    app))
