(ns degree9.auth
  (:require
   [javelin.core :as j]
   [goog.object :as obj]
   [meta.client :as client]
   [meta.promise :as prom])
  (:require-macros degree9.auth))

;; Authentication Cells ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn user-cell []
  (let [ucell (j/cell nil)
        ucell! (partial reset! ucell)]
    (j/cell= ucell #(ucell! (js->clj % :keywordize-keys true)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Helper Functions ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- auth-handler [auth user]
  (-> auth
    (prom/then #(let [] (prn %) %))
    (prom/then #(obj/get % "user"))
    (prom/then #(reset! user %))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Authentication Functions ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn auth! [app user]
  (auth-handler (client/auth! app) user))

(defn login! [app user strategy & [opts]]
  (auth-handler (client/login! app strategy opts) user))

(defn logout! [app user]
  (-> (client/logout! app)
    (prom/then #(reset! user nil))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
