(ns paysafe.core
  (:refer-clojure :exclude [get])
  (:require [degree9.env :as env]
            ["request-promise" :as req]))

(defn paysafe [endpoint data & [{:keys [qs] :as opts}]]
  (let [url (str (env/get "PAYSAFE_API_URL" "http://api.test.paysafe.com") endpoint)]
    (clj->js (merge data {:url url :qs qs}))))

(defn post [url data & [opts]]
  (req/post (paysafe url data opts)))

(defn get [url data & [opts]]
  (req/get (paysafe url data opts)))
