(ns degree9.paysafe.core
  (:refer-clojure :exclude [get])
  (:require [degree9.env :as env]
            [degree9.request :as req]))

(defn- paysafe-url
  ([] (paysafe-url "/"))
  ([path] (paysafe-url (env/get "PAYSAFE_API_URL" "http://api.test.paysafe.com") "/"))
  ([url path] (str url path)))

(defn paysafe [endpoint data & [{:keys [qs] :as opts}]]
  (let [url (str (env/get "PAYSAFE_API_URL" "http://api.test.paysafe.com") endpoint)]
    (clj->js (merge data {:url url :qs qs}))))

(defn post [url data & [opts]]
  (req/post url (paysafe data opts)))

(defn get [url data & [opts]]
  (req/get (paysafe url data opts)))
