(ns degree9.paysafe.core
  (:refer-clojure :exclude [get])
  (:require [degree9.env :as env]
            [degree9.request :as req]))

(defn- paysafe-url [path]
  (str (env/get "PAYSAFE_API_URL" "http://api.test.paysafe.com") path))

(defn paysafe [endpoint data & [{:keys [qs] :as opts}]]
  (let [url (paysafe-url endpoint)]
    (clj->js (merge data {:url url :qs qs}))))

(defn post [path data & [opts]]
  (let [url (paysafe-url path)]
    (req/post url (paysafe data opts))))

(defn get [url data & [opts]]
  (req/get (paysafe url data opts)))
