(ns degree9.paysafe.card
  (:require [degree9.paysafe.core :as ps]))

(defn create-authorization [data]
  (ps/post "/auths" data))

(defn get-authorization [id]
  (ps/get (str "/auths/" id)))

(defn update-authorization [id data]
  (ps/put (str "/auths/" id) data))

(defn void-authorization [id data]
  (ps/post (str "/auths/" id "/voidauths") data))

(defn get-void-authorization [id]
  (ps/get (str "/voidauths/" id)))

(defn settle-authorization [id data]
  (ps/post (str "/auths/" id "/settlements") data))

(defn get-settlement [id]
  (ps/get (str "/settlements/" id)))
