(ns degree9.paysafe.cards
  (:require [degree9.env :as env]
            [clojure.string :as cstr]
            [degree9.paysafe.core :as ps]))

;; Card Payments API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- cardpayments-url [path]
  (str "/cardpayments/v1/accounts/" (env/get "PAYSAFE_ACCOUNT_ID") path))

(defn create-authorization [data]
  (ps/post (cardpayments-url "/auths") data))

(defn get-authorization [id]
  (ps/get (str "/auths/" id)))

(defn update-authorization [id data]
  (ps/put (str "/auths/" id) data))

(defn void-authorization [id data]
  (ps/post (str "/auths/" id "/voidauths") data))

(defn get-void-authorization [id]
  (ps/get (str "/voidauths/" id)))

(defn settle-authorization [id data]
  (ps/post (str "/auths/" id "/settlements") data))

(defn get-settlement [id]
  (ps/get (str "/settlements/" id)))

(defn cancel-settlement [id data]
  (ps/put (str "/settlements/" id) data))

(defn submit-refund [id data]
  (ps/post (str "/settlements/" id "/refunds") data))

(defn get-refund [id]
  (ps/get (str "/refunds/" id)))

(defn cancel-refund [id data]
  (ps/put (str "/refunds/" id) data))

(defn create-verification [data]
  (ps/post "/verifications" data))

(defn get-verification [id]
  (ps/get (str "/verifications/" id)))

;; TODO: Standalone & Original Credits have not been implemented

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
