(ns degree9.paysafe.cards
  (:require [degree9.env :as env]
            [clojure.string :as cstr]
            [degree9.paysafe.core :as ps]))

;; Card Payments API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn cardpayments-url [& paths]
  (cstr/join (into ["/cardpayments/v1/accounts/" (env/get "PAYSAFE_ACCOUNT_ID")] paths)))

(defn create-authorization [data]
  (ps/post (cardpayments-url "/auths") data))

(defn get-authorization [id]
  (ps/get (cardpayments-url "/auths/" id)))

(defn update-authorization [id data]
  (ps/put (cardpayments-url "/auths/" id) data))

(defn void-authorization [id data]
  (ps/post (cardpayments-url "/auths/" id "/voidauths") data))

(defn get-void-authorization [id]
  (ps/get (cardpayments-url "/voidauths/" id)))

(defn settle-authorization [id data]
  (ps/post (cardpayments-url "/auths/" id "/settlements") data))

(defn get-settlement [id]
  (ps/get (cardpayments-url "/settlements/" id)))

(defn cancel-settlement [id data]
  (ps/put (cardpayments-url "/settlements/" id) data))

(defn submit-refund [id data]
  (ps/post (cardpayments-url "/settlements/" id "/refunds") data))

(defn get-refund [id]
  (ps/get (cardpayments-url "/refunds/" id)))

(defn cancel-refund [id data]
  (ps/put (cardpayments-url "/refunds/" id) data))

(defn create-verification [data]
  (ps/post (cardpayments-url "/verifications") data))

(defn get-verification [id]
  (ps/get (cardpayments-url "/verifications/" id)))

;; TODO: Standalone & Original Credits have not been implemented

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
