(ns degree9.wizard
  "Handles state for building a wizard component."
  (:require [hoplon.core :as h]
            [uikit-hl.modal :as modal]
            [uikit-hl.text :as text]))

(defn- current-step [needle haystack]
  (keep-indexed #(when (= %2 needle) %1) haystack))

(h/defelem wizard-modal [attr kids]
  (let [steps  (:steps attr (j/cell []))
        current (:current attr (j/cell nil))
        wizard (j/cell= {:steps steps})]
    (modal/modal
      (modal/dialog
        (modal/header
          (motal/title (:title attr)))
        (modal/body
          (h/case-tpl (:step wizard)))
        (modal/footer
          (h/div ::text/left true
            (h/text "~{(str (current-step current steps) \"/\" (count steps))}")))))))
