(ns degree9.service
 (:require ["socket.io-client" :as io]
           ["@feathersjs/feathers" :as feathers]
           ["@feathersjs/socketio-client" :as socketio]
           [meta.server :as server]
           [degree9.debug :as dbg]))

(dbg/defdebug debug "degree9:enterprise:service")

(defn mksocket
  "Create a websocket connection to remote microservice."
  [app uri]
  (debug "Create websocket connection to remote microservice at %s" uri)
  (let [socket (io uri)]
    (doto app
      (.configure (socketio socket)))))

(defn µservice [uri service]
  (debug "Initializing Remote Microservice at %s/%s" uri service)
  (let [client (feathers)]
    (.service (mksocket client uri) service)))

(defn api
  "Mount a remote Microservice to a local endpoint."
  [app path uri service hooks]
  (debug "Mount Remote Microservice at %s" path)
  (server/api app path (µservice uri service) hooks))
