(ns degree9.auth.api-key
  (:require [degree9.debug :as dbg]
            [degree9.object :as obj]
            ["@feathersjs/authentication" :as auth]))


(def ^:private debug (dbg/debug "degree9:enterprise:auth:api-key"))

(def APIKeyStrategy (obj/get auth "AuthenticationBaseStrategy"))

(set! (.. oauth/OAuthStrategy -prototype -getProfile)
  (fn [data & args]
    (debug "getProfile raw data " data)
    (-> data
      (obj/get "id_token")
      (obj/get "payload"))))

(set! (.. oauth/OAuthStrategy -prototype -getEntityData)
  (fn [data & args]
    (debug "getEntityData raw data " data)
    #js{:email (first (obj/get data "emails"))}))

(set! (.. oauth/OAuthStrategy -prototype -getEntityQuery)
  (fn [data & args]
    (debug "getEntityQuery raw data " data)
    #js{:email (first (obj/get data "emails"))}))

(defn with-api-key [app & opts]
  (let [auth (.service app "/authentication")
        svc  (APIKeyStrategy.)]
    (debug "Registering API Key auth strategy.")
    (.register auth "api-key" svc)
    app))
