(ns degree9.es6
  (:require [cljs.analyzer :as ana]
            [cljs.compiler :as compiler]))

;; Native ES6 Class compiler extension ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(alter-var-root #'ana/specials #(conj % 'es6class*))

(defmethod ana/parse 'es6class*
  [op env [_ sym & exprs :as form] _ _]
  {:env env
   :op :es6class
   :children [:methods]
   :methods (ana/disallowing-recur
                 (->> (rest exprs)
                      (mapv #(ana/analyze (assoc env :context :method) %))))
   :form form
   :class sym})

(defmethod compiler/emit* :es6class
  [{:keys [methods class]}]
  (compiler/emits "class ")
  (compiler/emits class)
  (compiler/emits " {")
  (doseq [m methods]
    (compiler/emitln m))
  (compiler/emits "}"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Public Async/Await API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro defclass
  "Wraps body in native es6 class block."
  [name & body]
  `(def ~name (~'es6class* ~name ~@body)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
