(ns degree9.es6
  (:require [cljs.analyzer :as ana]
            [cljs.compiler :as compiler]))

;; Native ES6 Class compiler extension ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(alter-var-root #'ana/specials #(conj % 'es6class*))

(defmethod ana/parse 'class*
  [op env [_ sym & exprs :as form] _ _]
  {:env env
   :op :class
   :children [:methods]
   :methods (ana/disallowing-recur
                 (->> (rest exprs)
                      (mapv #(ana/analyze (assoc env :context :method) %))))
   :form form
   :class sym})

(defmethod compiler/emit* :class
  [{:keys [methods class]}]
  (compiler/emits "class ")
  (compiler/emits class)
  (compiler/emits " {")
  (doseq [m methods]
    (compiler/emitln m))
  (compiler/emits "}"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Public Async/Await API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro class
  "Wraps body in native es6 class block."
  [name & body]
  `(let [~'constructor ~'class-constructor*
         ~'method ~'class-method*]
     (~'class* ~name ~@body)))

(defmacro defclass
  "Define a native es6 class."
  [name & body]
  `(def ~name (~'class ~name ~@body)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
