(ns degree9.es6
  (:refer-clojure :exclude [class])
  (:require [cljs.analyzer :as ana]
            [cljs.compiler :as compiler]))

;; Native ES6 Class compiler extension ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(alter-var-root #'ana/specials #(conj % 'class* 'method* 'super*))

(defmethod ana/parse 'class*
  [op env [_ class extends methods :as form] _ _]
  (let [methods (map (fn [[method params & body]] {:method method :params params :body body}) methods)]
    {:env env
     :op :class
     :children [:methods]
     :class class
     :methods (ana/disallowing-recur
                 (->> methods
                      (mapv #(ana/analyze (assoc env :context :method) %))))
     :extends extends
     :form form}))

(defmethod compiler/emit* :class
  [{:keys [class extends methods]}]
  (let [extends (when extends (str " extends " extends))]
    (compiler/emitln "class " class extends " {")
    ;(compiler/emitln "constructor( " (interpose "," (map compiler/munge args)) ") {")
    (doseq [{:keys [method params body]} methods]
      (compiler/emitln method "(" (interpose "," (map compiler/munge params)) ") {"
        (doseq))
      (compiler/emits "}"))
    ; (doseq [m methods]
    ;   (compiler/emitln m))
    (compiler/emits "}")))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ES6 Class API ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmacro class
  "Create a named or unnamed javascript class. (es6+)"
  ([] (class constructor-fn {}))
  ([methods] (class nil methods))
  ([name methods] (class name nil methods))
  ([name extends methods] `(~'class* ~name ~extends ~methods)))

(defmacro defclass
  "Define a named javascript class. (es6+)"
  ([name & [extends & methods :as body]]
   (let [extends (when (symbol? extends) extends)
         methods (if extends methods body)]
     `(def ~name (~'class ~name ~extends ~methods)))))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
