(ns degree9.azure.insights.client
  "Azure Application Insights Browser Client"
  (:require ["@microsoft/applicationinsights-web" :as insights]
            [degree9.env :as env]
            [goog.object :as obj]))

(def ApplicationInsights (obj/get insights "ApplicationInsights"))

(defn init! [& [conf]]
  (let [config (merge {:config {:instrumentationKey (env/get "")}} conf)]
    (.loadAppInsights client (clj->js config))))

(defn setup [config] (ApplicationInsights. (clj->js config)))

(defn start [client]
  (.loadAppInsights client))

(defn init!
  ([] (init! {:config {:instrumentationKey (env/get "APPINSIGHTS_INSTRUMENTATIONKEY")}}))
  ([ikey] (start (setup ikey))))
