(ns degree9.routing
  (:require ;[goog.url :as url]
            [goog.events :as events]
            [goog.Uri :as uri]
            [goog.Uri.QueryData :as qd]
            [javelin.core :as j]
            [degree9.string :as str])
  (:require-macros degree9.routing)
  (:import [goog History Uri]
           [goog.history Html5History EventType]))

;; need to rewrite this with goog.url once closure library is updated

; (defn- mkurl
;   ([] (mkurl (.-location js/window)))
;   ([url] (js/URL. url)))
;
; (def ^:dynamic *url* (mkurl))

; (defn- url-cell [& {:keys [url] :as opts}]
;   (let [url (or url *url*)
;         urlc (j/cell url)]
;     (j/with-let [urlc= (j/cell= urlc (fn [url] (reset! urlc (mkurl url))))]
;       (events/listen js/window EventType.HASHCHANGE
;         (fn [event] (reset! urlc (.-location js/window)))))))
;
; (def url (url-cell))
;
; (j/cell= (.log js/console "url" url))

(defn mkhistory [{:keys [prefix fragment] :or {prefix "" fragment true}}]
   (if (Html5History.isSupported)
     (doto (Html5History.)
       (.setPathPrefix  prefix)
       (.setUseFragment fragment))
     (History.)))

(defn history-cell [& [opts]]
  (let [history  (mkhistory opts)
        historyc (j/cell (.getToken history))]
   (j/with-let [_ (j/cell= historyc (fn [token] (.setToken history token)))]
     (events/listen history EventType.NAVIGATE
       (fn [event] (.log js/console event) (reset! historyc (.-token event))))
     (.setEnabled history true))))

;; History State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def history (history-cell {:prefix "/" :fragment false}))

(j/cell= (prn "history" history))

; (defn- history-state []
;   (let [history (.-history js/window)
;         historyc (j/cell (.-state history))]
;     (j/with-let [_ (j/cell= historyc (fn [state] (.pushState history (clj->js state) (.-title js/document))))]
;       (events/listen js/window EventType.POPSTATE
;         (fn [event] (reset! historyc (.-state event)))))))
;
; (def state (history-state))
;
; (j/cell= (.log js/console "state" state))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(j/defc= uri (when history (uri/parse (.-location js/window))) #(reset! history (.toString %)))

(j/cell= (.log js/console "uri" uri))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI Path State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(j/defc= path (.getPath uri) #(reset! uri (.setPath @uri %)))

(j/cell= (prn "path" path))

(defn path! [p]
  (reset! path p))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; URI Query State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- clj->query [data]
  (qd/createFromMap (clj->js data)))

(j/defc= query (.getQueryData uri) #(reset! uri (.setQueryData @uri (clj->query %))))

(j/cell= (.log js/console "query" query))

(defn query-cell [key & [default]]
  (j/cell= (.get query (name key) default) #(reset! query (.set @query (name key) %))))

(defn query! [q]
  (reset! query q))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; App Route State ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn- path->kw [path]
  (mapv keyword (remove empty? (str/split path "/"))))

(defn- kw->path [& korks]
  (str/join "/" (mapv name (flatten korks))))

(j/defc= route (path->kw path) #(reset! path (kw->path %)))

(j/cell= (prn "route" route))

; (defn router
;   ([routes] (router routes nil))
;   ([routes default] (j/cell= (pw/match-route routes path default))))

(defn route! [path & [query]]
  (j/dosync
    (when query ())
    (reset! history path)))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
