(ns degree9.events)

(defn listen [target event listener]
  (.addEventListener target event listener))

(defn unlisten [target event listener]
  (.removeEventListener target event listener))

(def types
  {:popstate "popstate"})

(defn event
  ([type init] (event js/Event type init))
  ([event type init] (event. (type types) (clj->js init))))

(defn popstate [state]
  (event js/PopStateEvent :popstate {:state state}))
