(ns degree9.browser.storage)

(defprotocol IStorage
  "Interface for interacting with Web Storage API."
  (key         [this index]     "Returns name of nth key.")
  (get-item    [this key]       "Return keys value or null.")
  (set-item    [this key value] "Adds key to storage or updates it's value.")
  (remove-item [this key]       "Removes keys from storage if it exists.")
  (clear       [this]           "Clears all keys from storage."))
