(ns degree9.browser.history
  (:require [degree9.browser :as bom]
            [degree9.events :as events]))

(defprotocol IHistory
  "Interface for interacting with HTML5 History API."
  (back [this] "Returns name of nth key.")
  (forward [this] "Return keys value or null.")
  (go [this delta] "Adds key to storage or updates it's value.")
  (push-state [this state title] [this state title url] "Removes keys from storage if it exists.")
  (replace-state [this state title] [this state title url] "Clears all keys from storage."))

(defn push-state! [state title path]
  (.pushState (bom/get-history) (clj->js state) title path))

(defn replace-state! [state title path]
  (.replaceState (bom/get-history) (clj->js state) title path))

(defn popstate! [state]
  (events/dispatch! (bom/get-window) (events/popstate state)))
