(ns degree9.storage
  (:require [javelin.core :as j]
            [degree9.object :as obj]
            [degree9.browser :as bom]
            [degree9.browser.storage :as store]
            [degree9.events :as events]))

(defn local-storage [key]
  (let [local (bom/local-storage)
        store (j/cell (store/get-item local key))]
    (j/with-let [store= (j/cell= store (partial store/set-item local key))]
      (events/listen (bom/get-window) :storage
        (fn [event]
          (when (and (= (:key event) key)
                     (= (:storageArea event) local))
            (reset! store (:newValue event))))))))

(defn session-storage [key]
  (let [session (bom/session-storage)
        store (j/cell (store/get-item session key))]
    (j/with-let [store= (j/cell= store (partial store/set-item session key))]
      (events/listen (bom/get-window) :storage
        (fn [event]
          (when (and (= (:key event) key)
                     (= (:storageArea event) session))
            (reset! store (:newValue event))))))))
