(ns degree9.indexed-db
  (:require [degree9.browser.indexed-db.opendbrequest :as oreq]))

(defn upgrade-database! [db config]
  (oreq/onupgradeneeded db
    (fn [event]
      (let [[old new] (get-version event)
            db (get-result event)]
        (loop [old old new new]
          (when-not (> old new)
            (when-let [stores (get config old)]
              (create-stores db stores)
              (delete-stores db stores))
            (recur (inc old) new)))))))
