(ns feathers.app)

(defmacro with-promise [hook & body]
  `(fn [hook#]
    (js/Promise.
      (fn [resolve# _#]
        (let [~hook hook#
              result# (do ~@body)]
          (resolve# result#))))))

(defmacro with-hook [hook & body]
  `(fn [hook#]
    (let [~hook hook#
          result# (do ~@body)]
        ~hook)))
