(ns feathers.services
  (:refer-clojure :exclude [find get update remove])
  (:require [cljs.nodejs :as node]
            [feathers.core :as fs]))

(def service fs/service)

(defn on [service callback]
  (.on service callback))

(defn find [service & [params callback]]
  (.find service (or params {}) callback))

(defn get [service id & [params callback]]
  (.get service id (or params {}) callback))

(defn create [service data & [params callback]]
  (.create service (clj->js data) (or params {}) callback))

(defn update [service id data & [params callback]]
  (.update service id (clj->js data) (or params {}) callback))

(defn patch [service id data & [params callback]]
  (.patch service id (clj->js data) (or params {}) callback))

(defn remove [service id & [params callback]]
  (.remove service id (or params {}) callback))

(defn setup [service app path]
  (.setup service app path))
