(ns feathers.client.services
  (:refer-clojure :exclude [find get update remove])
  (:require [feathers.client :as feathers]))

(def service feathers/service)

(defn on [app event callback]
  (.on app event callback))

(defn created [app callback]
  (.on app "created" callback))

(defn updated [app callback]
  (.on app "updated" callback))

(defn patched [app callback]
  (.on app "patched" callback))

(defn removed [app callback]
  (.on app "removed" callback))

(defn find [app & [params]]
   (.find app params))

(defn get [app id & [params]]
   (.get app id params))

(defn create [app data & [params]]
   (.create app data params))

(defn update [app id data & [params]]
  (.update app id data params))

(defn patch [app id data & [params]]
  (.patch app id data params))

(defn remove [app id & [params]]
  (.remove app id params))
