(ns feathers.application
  (:refer-clojure :exclude [rest])
  (:require [goog.object :as obj]
            [feathers.authentication :as auth]
            ["@feathersjs/feathers" :as feathers]
            [feathers.configuration :as config]
            [feathers.rest :as rest]
            [feathers.socketio :as socketio]
            [feathers.express :as exp])
  (:require-macros feathers.application))

(def app feathers)

(def express exp/expressify)

(def json exp/json)

(def urlencoded exp/urlencoded)

(def static exp/static)

(def not-found exp/not-found)

(def error-handler exp/error-handler)

(def configuration config/configure)

(def rest rest/configure)

(def socketio socketio/configure)

(def authentication auth/configure)

(def listen feathers/listen)

(def using feathers/use)

(defn api [app path svc & [{:keys [before after error]}]]
  (let [app (.use app path svc)]
    (doto (.service app path)
      (.hooks (clj->js {:before before :after after :error error})))
    app))

(defn configure
  [app callback]
  (.configure app callback))

(defn listen
  [app & [port]]
  (.listen app port))

(defn setup
  [app server]
  (.setup app server))

(defn service
  ([app path] (.service app path))
  ([app path service] (.service app path service)))

(defn hooks
 ([app hook]
  (.hooks app (clj->js hook)))
 ([app path hook]
  (.hooks (service app path) (clj->js hook))))
