// Compiled by ClojureScript 1.9.521 {}
goog.provide('schema.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('schema.utils');
goog.require('schema.spec.core');
goog.require('schema.spec.leaf');
goog.require('schema.spec.variant');
goog.require('schema.spec.collection');

/**
 * @interface
 */
schema.core.Schema = function(){};

/**
 * A spec is a record of some type that expresses the structure of this schema
 *   in a declarative and/or imperative way.  See schema.spec.* for examples.
 */
schema.core.spec = (function schema$core$spec(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$spec$arity$1 == null)))){
return this$.schema$core$Schema$spec$arity$1(this$);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (schema.core.spec[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$);
} else {
var m__7851__auto____$1 = (schema.core.spec["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.spec",this$);
}
}
}
});

/**
 * Expand this schema to a human-readable format suitable for pprinting,
 *   also expanding class schematas at the leaves.  Example:
 * 
 *   user> (s/explain {:a s/Keyword :b [s/Int]} )
 *   {:a Keyword, :b [Int]}
 */
schema.core.explain = (function schema$core$explain(this$){
if((!((this$ == null))) && (!((this$.schema$core$Schema$explain$arity$1 == null)))){
return this$.schema$core$Schema$explain$arity$1(this$);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (schema.core.explain[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$);
} else {
var m__7851__auto____$1 = (schema.core.explain["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Schema.explain",this$);
}
}
}
});

/**
 * Compile an efficient checker for schema, which returns nil for valid values and
 * error descriptions otherwise.
 */
schema.core.checker = (function schema$core$checker(schema__$1){
return cljs.core.comp.call(null,schema.utils.error_val,schema.spec.core.run_checker.call(null,(function (s,params){
return schema.spec.core.checker.call(null,schema.core.spec.call(null,s),params);
}),false,schema__$1));
});
/**
 * Return nil if x matches schema; otherwise, returns a value that looks like the
 * 'bad' parts of x with ValidationErrors at the leaves describing the failures.
 * 
 * If you will be checking many datums, it is much more efficient to create
 * a 'checker' once and call it on each of them.
 */
schema.core.check = (function schema$core$check(schema__$1,x){
return schema.core.checker.call(null,schema__$1).call(null,x);
});
/**
 * Compile an efficient validator for schema.
 */
schema.core.validator = (function schema$core$validator(schema__$1){
var c = schema.core.checker.call(null,schema__$1);
return ((function (c){
return (function (value){
var temp__4657__auto___11651 = c.call(null,value);
if(cljs.core.truth_(temp__4657__auto___11651)){
var error_11652 = temp__4657__auto___11651;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Value does not match schema: %s",cljs.core.pr_str.call(null,error_11652)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"error","error",-978969032),error_11652], null));
} else {
}

return value;
});
;})(c))
});
/**
 * Throw an exception if value does not satisfy schema; otherwise, return value.
 * If you will be validating many datums, it is much more efficient to create
 * a 'validator' once and call it on each of them.
 */
schema.core.validate = (function schema$core$validate(schema__$1,value){
return schema.core.validator.call(null,schema__$1).call(null,value);
});
schema.core.instance_precondition = (function schema$core$instance_precondition(s,klass){
return schema.spec.core.precondition.call(null,s,(function (p1__11653_SHARP_){
var and__7170__auto__ = !((p1__11653_SHARP_ == null));
if(and__7170__auto__){
var or__7182__auto__ = (klass === p1__11653_SHARP_.constructor);
if(or__7182__auto__){
return or__7182__auto__;
} else {
return p1__11653_SHARP_ instanceof klass;
}
} else {
return and__7170__auto__;
}
}),(function (p1__11654_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = klass;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11654_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
}));
});
(schema.core.Schema["function"] = true);

(schema.core.spec["function"] = (function (this$){
var pre = schema.core.instance_precondition.call(null,this$,this$);
var temp__4655__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__4655__auto__)){
var class_schema = temp__4655__auto__;
return schema.spec.variant.variant_spec.call(null,pre,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),class_schema], null)], null));
} else {
return schema.spec.leaf.leaf_spec.call(null,pre);
}
}));

(schema.core.explain["function"] = (function (this$){
var temp__4655__auto__ = schema.utils.class_schema.call(null,this$);
if(cljs.core.truth_(temp__4655__auto__)){
var more_schema = temp__4655__auto__;
return schema.core.explain.call(null,more_schema);
} else {
var pred__11655 = cljs.core._EQ_;
var expr__11656 = this$;
if(cljs.core.truth_(pred__11655.call(null,null,expr__11656))){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
if(cljs.core.truth_(pred__11655.call(null,Boolean,expr__11656))){
return new cljs.core.Symbol(null,"Bool","Bool",195910502,null);
} else {
if(cljs.core.truth_(pred__11655.call(null,Number,expr__11656))){
return new cljs.core.Symbol(null,"Num","Num",-2044934708,null);
} else {
if(cljs.core.truth_(pred__11655.call(null,null,expr__11656))){
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
} else {
if(cljs.core.truth_(pred__11655.call(null,Date,expr__11656))){
return new cljs.core.Symbol(null,"Inst","Inst",292408622,null);
} else {
if(cljs.core.truth_(pred__11655.call(null,cljs.core.UUID,expr__11656))){
return new cljs.core.Symbol(null,"Uuid","Uuid",-1866694318,null);
} else {
return this$;
}
}
}
}
}
}
}
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.AnythingSchema = (function (_,__meta,__extmap,__hash){
this._ = _;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.AnythingSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11659,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11661 = (((k11659 instanceof cljs.core.Keyword))?k11659.fqn:null);
switch (G__11661) {
case "_":
return self__._;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11659,else__7812__auto__);

}
});

schema.core.AnythingSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.AnythingSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.AnythingSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11658){
var self__ = this;
var G__11658__$1 = this;
return (new cljs.core.RecordIter((0),G__11658__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"_","_",1453416199)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.AnythingSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.AnythingSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.AnythingSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"_","_",1453416199),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11658){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11662 = cljs.core.keyword_identical_QMARK_;
var expr__11663 = k__7817__auto__;
if(cljs.core.truth_(pred__11662.call(null,new cljs.core.Keyword(null,"_","_",1453416199),expr__11663))){
return (new schema.core.AnythingSchema(G__11658,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.AnythingSchema(self__._,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11658),null));
}
});

schema.core.AnythingSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"_","_",1453416199),self__._],null))], null),self__.__extmap));
});

schema.core.AnythingSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11658){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.AnythingSchema(self__._,G__11658,self__.__extmap,self__.__hash));
});

schema.core.AnythingSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.AnythingSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.AnythingSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_);
});

schema.core.AnythingSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Any","Any",1277492269,null);
});

schema.core.AnythingSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"_","_",-1201019570,null)], null);
});

schema.core.AnythingSchema.cljs$lang$type = true;

schema.core.AnythingSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/AnythingSchema");
});

schema.core.AnythingSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/AnythingSchema");
});

schema.core.__GT_AnythingSchema = (function schema$core$__GT_AnythingSchema(_){
return (new schema.core.AnythingSchema(_,null,null,null));
});

schema.core.map__GT_AnythingSchema = (function schema$core$map__GT_AnythingSchema(G__11660){
return (new schema.core.AnythingSchema(new cljs.core.Keyword(null,"_","_",1453416199).cljs$core$IFn$_invoke$arity$1(G__11660),null,cljs.core.dissoc.call(null,G__11660,new cljs.core.Keyword(null,"_","_",1453416199)),null));
});

/**
 * Any value, including nil.
 */
schema.core.Any = (new schema.core.AnythingSchema(null,null,null,null));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.EqSchema = (function (v,__meta,__extmap,__hash){
this.v = v;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.EqSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11669,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11671 = (((k11669 instanceof cljs.core.Keyword))?k11669.fqn:null);
switch (G__11671) {
case "v":
return self__.v;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11669,else__7812__auto__);

}
});

schema.core.EqSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.EqSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EqSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11668){
var self__ = this;
var G__11668__$1 = this;
return (new cljs.core.RecordIter((0),G__11668__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"v","v",21465059)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.EqSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.EqSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.EqSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EqSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"v","v",21465059),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.EqSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11668){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11672 = cljs.core.keyword_identical_QMARK_;
var expr__11673 = k__7817__auto__;
if(cljs.core.truth_(pred__11672.call(null,new cljs.core.Keyword(null,"v","v",21465059),expr__11673))){
return (new schema.core.EqSchema(G__11668,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EqSchema(self__.v,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11668),null));
}
});

schema.core.EqSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"v","v",21465059),self__.v],null))], null),self__.__extmap));
});

schema.core.EqSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11668){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.EqSchema(self__.v,G__11668,self__.__extmap,self__.__hash));
});

schema.core.EqSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.EqSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EqSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11666_SHARP_){
return cljs.core._EQ_.call(null,self__.v,p1__11666_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11667_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = self__.v;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11667_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"=","=",-1501502141,null));
});})(this$__$1))
));
});

schema.core.EqSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = self__.v;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"eq","eq",1021992460,null));
});

schema.core.EqSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null);
});

schema.core.EqSchema.cljs$lang$type = true;

schema.core.EqSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EqSchema");
});

schema.core.EqSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/EqSchema");
});

schema.core.__GT_EqSchema = (function schema$core$__GT_EqSchema(v){
return (new schema.core.EqSchema(v,null,null,null));
});

schema.core.map__GT_EqSchema = (function schema$core$map__GT_EqSchema(G__11670){
return (new schema.core.EqSchema(new cljs.core.Keyword(null,"v","v",21465059).cljs$core$IFn$_invoke$arity$1(G__11670),null,cljs.core.dissoc.call(null,G__11670,new cljs.core.Keyword(null,"v","v",21465059)),null));
});

/**
 * A value that must be (= v).
 */
schema.core.eq = (function schema$core$eq(v){
return (new schema.core.EqSchema(v,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Isa = (function (h,parent,__meta,__extmap,__hash){
this.h = h;
this.parent = parent;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Isa.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11679,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11681 = (((k11679 instanceof cljs.core.Keyword))?k11679.fqn:null);
switch (G__11681) {
case "h":
return self__.h;

break;
case "parent":
return self__.parent;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11679,else__7812__auto__);

}
});

schema.core.Isa.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Isa{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Isa.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11678){
var self__ = this;
var G__11678__$1 = this;
return (new cljs.core.RecordIter((0),G__11678__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Isa.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Isa.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Isa.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Isa.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"parent","parent",-878878779),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Isa.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11678){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11682 = cljs.core.keyword_identical_QMARK_;
var expr__11683 = k__7817__auto__;
if(cljs.core.truth_(pred__11682.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__11683))){
return (new schema.core.Isa(G__11678,self__.parent,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11682.call(null,new cljs.core.Keyword(null,"parent","parent",-878878779),expr__11683))){
return (new schema.core.Isa(self__.h,G__11678,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Isa(self__.h,self__.parent,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11678),null));
}
}
});

schema.core.Isa.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent","parent",-878878779),self__.parent],null))], null),self__.__extmap));
});

schema.core.Isa.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11678){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Isa(self__.h,self__.parent,G__11678,self__.__extmap,self__.__hash));
});

schema.core.Isa.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Isa.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Isa.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11676_SHARP_){
return cljs.core.isa_QMARK_.call(null,self__.h,p1__11676_SHARP_,self__.parent);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11677_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__11677_SHARP_;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = self__.parent;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});})(this$__$1))
));
});

schema.core.Isa.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = self__.parent;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"isa?","isa?",1358492324,null));
});

schema.core.Isa.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"h","h",-1544777029,null),new cljs.core.Symbol(null,"parent","parent",761652748,null)], null);
});

schema.core.Isa.cljs$lang$type = true;

schema.core.Isa.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Isa");
});

schema.core.Isa.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Isa");
});

schema.core.__GT_Isa = (function schema$core$__GT_Isa(h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.map__GT_Isa = (function schema$core$map__GT_Isa(G__11680){
return (new schema.core.Isa(new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__11680),new cljs.core.Keyword(null,"parent","parent",-878878779).cljs$core$IFn$_invoke$arity$1(G__11680),null,cljs.core.dissoc.call(null,G__11680,new cljs.core.Keyword(null,"h","h",1109658740),new cljs.core.Keyword(null,"parent","parent",-878878779)),null));
});

/**
 * A value that must be a child of parent.
 */
schema.core.isa = (function schema$core$isa(var_args){
var args11686 = [];
var len__8295__auto___11689 = arguments.length;
var i__8296__auto___11690 = (0);
while(true){
if((i__8296__auto___11690 < len__8295__auto___11689)){
args11686.push((arguments[i__8296__auto___11690]));

var G__11691 = (i__8296__auto___11690 + (1));
i__8296__auto___11690 = G__11691;
continue;
} else {
}
break;
}

var G__11688 = args11686.length;
switch (G__11688) {
case 1:
return schema.core.isa.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.isa.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11686.length)].join('')));

}
});

schema.core.isa.cljs$core$IFn$_invoke$arity$1 = (function (parent){
return (new schema.core.Isa(null,parent,null,null,null));
});

schema.core.isa.cljs$core$IFn$_invoke$arity$2 = (function (h,parent){
return (new schema.core.Isa(h,parent,null,null,null));
});

schema.core.isa.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.EnumSchema = (function (vs,__meta,__extmap,__hash){
this.vs = vs;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.EnumSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11696,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11698 = (((k11696 instanceof cljs.core.Keyword))?k11696.fqn:null);
switch (G__11698) {
case "vs":
return self__.vs;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11696,else__7812__auto__);

}
});

schema.core.EnumSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.EnumSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EnumSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11695){
var self__ = this;
var G__11695__$1 = this;
return (new cljs.core.RecordIter((0),G__11695__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"vs","vs",-2022097090)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.EnumSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.EnumSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.EnumSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.EnumSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"vs","vs",-2022097090),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11695){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11699 = cljs.core.keyword_identical_QMARK_;
var expr__11700 = k__7817__auto__;
if(cljs.core.truth_(pred__11699.call(null,new cljs.core.Keyword(null,"vs","vs",-2022097090),expr__11700))){
return (new schema.core.EnumSchema(G__11695,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.EnumSchema(self__.vs,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11695),null));
}
});

schema.core.EnumSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"vs","vs",-2022097090),self__.vs],null))], null),self__.__extmap));
});

schema.core.EnumSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11695){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.EnumSchema(self__.vs,G__11695,self__.__extmap,self__.__hash));
});

schema.core.EnumSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.EnumSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.EnumSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11693_SHARP_){
return cljs.core.contains_QMARK_.call(null,self__.vs,p1__11693_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11694_SHARP_){
var x__8024__auto__ = self__.vs;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11694_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
});})(this$__$1))
));
});

schema.core.EnumSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"enum","enum",-975417337,null),self__.vs);
});

schema.core.EnumSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"vs","vs",-381565563,null)], null);
});

schema.core.EnumSchema.cljs$lang$type = true;

schema.core.EnumSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/EnumSchema");
});

schema.core.EnumSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/EnumSchema");
});

schema.core.__GT_EnumSchema = (function schema$core$__GT_EnumSchema(vs){
return (new schema.core.EnumSchema(vs,null,null,null));
});

schema.core.map__GT_EnumSchema = (function schema$core$map__GT_EnumSchema(G__11697){
return (new schema.core.EnumSchema(new cljs.core.Keyword(null,"vs","vs",-2022097090).cljs$core$IFn$_invoke$arity$1(G__11697),null,cljs.core.dissoc.call(null,G__11697,new cljs.core.Keyword(null,"vs","vs",-2022097090)),null));
});

/**
 * A value that must be = to some element of vs.
 */
schema.core.enum$ = (function schema$core$enum(var_args){
var args__8302__auto__ = [];
var len__8295__auto___11704 = arguments.length;
var i__8296__auto___11705 = (0);
while(true){
if((i__8296__auto___11705 < len__8295__auto___11704)){
args__8302__auto__.push((arguments[i__8296__auto___11705]));

var G__11706 = (i__8296__auto___11705 + (1));
i__8296__auto___11705 = G__11706;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic = (function (vs){
return (new schema.core.EnumSchema(cljs.core.set.call(null,vs),null,null,null));
});

schema.core.enum$.cljs$lang$maxFixedArity = (0);

schema.core.enum$.cljs$lang$applyTo = (function (seq11703){
return schema.core.enum$.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11703));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Predicate = (function (p_QMARK_,pred_name,__meta,__extmap,__hash){
this.p_QMARK_ = p_QMARK_;
this.pred_name = pred_name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Predicate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11709,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11711 = (((k11709 instanceof cljs.core.Keyword))?k11709.fqn:null);
switch (G__11711) {
case "p?":
return self__.p_QMARK_;

break;
case "pred-name":
return self__.pred_name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11709,else__7812__auto__);

}
});

schema.core.Predicate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Predicate{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Predicate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11708){
var self__ = this;
var G__11708__$1 = this;
return (new cljs.core.RecordIter((0),G__11708__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Predicate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Predicate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Predicate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Predicate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),null,new cljs.core.Keyword(null,"p?","p?",-1172161701),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Predicate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11708){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11712 = cljs.core.keyword_identical_QMARK_;
var expr__11713 = k__7817__auto__;
if(cljs.core.truth_(pred__11712.call(null,new cljs.core.Keyword(null,"p?","p?",-1172161701),expr__11713))){
return (new schema.core.Predicate(G__11708,self__.pred_name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11712.call(null,new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),expr__11713))){
return (new schema.core.Predicate(self__.p_QMARK_,G__11708,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11708),null));
}
}
});

schema.core.Predicate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p?","p?",-1172161701),self__.p_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pred-name","pred-name",-3677451),self__.pred_name],null))], null),self__.__extmap));
});

schema.core.Predicate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11708){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Predicate(self__.p_QMARK_,self__.pred_name,G__11708,self__.__extmap,self__.__hash));
});

schema.core.Predicate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Predicate.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Predicate.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,self__.p_QMARK_,((function (this$__$1){
return (function (p1__11707_SHARP_){
var x__8024__auto__ = self__.pred_name;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11707_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
});})(this$__$1))
));
});

schema.core.Predicate.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.integer_QMARK_)){
return new cljs.core.Symbol(null,"Int","Int",-2116888740,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.keyword_QMARK_)){
return new cljs.core.Symbol(null,"Keyword","Keyword",-850065993,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.symbol_QMARK_)){
return new cljs.core.Symbol(null,"Symbol","Symbol",716452869,null);
} else {
if(cljs.core._EQ_.call(null,self__.p_QMARK_,cljs.core.string_QMARK_)){
return new cljs.core.Symbol(null,"Str","Str",907970895,null);
} else {
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = self__.pred_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"pred","pred",-727012372,null));

}
}
}
}
});

schema.core.Predicate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p?","p?",468369826,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null);
});

schema.core.Predicate.cljs$lang$type = true;

schema.core.Predicate.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Predicate");
});

schema.core.Predicate.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Predicate");
});

schema.core.__GT_Predicate = (function schema$core$__GT_Predicate(p_QMARK_,pred_name){
return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.map__GT_Predicate = (function schema$core$map__GT_Predicate(G__11710){
return (new schema.core.Predicate(new cljs.core.Keyword(null,"p?","p?",-1172161701).cljs$core$IFn$_invoke$arity$1(G__11710),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451).cljs$core$IFn$_invoke$arity$1(G__11710),null,cljs.core.dissoc.call(null,G__11710,new cljs.core.Keyword(null,"p?","p?",-1172161701),new cljs.core.Keyword(null,"pred-name","pred-name",-3677451)),null));
});

/**
 * A value for which p? returns true (and does not throw).
 * Optional pred-name can be passed for nicer validation errors.
 */
schema.core.pred = (function schema$core$pred(var_args){
var args11716 = [];
var len__8295__auto___11719 = arguments.length;
var i__8296__auto___11720 = (0);
while(true){
if((i__8296__auto___11720 < len__8295__auto___11719)){
args11716.push((arguments[i__8296__auto___11720]));

var G__11721 = (i__8296__auto___11720 + (1));
i__8296__auto___11720 = G__11721;
continue;
} else {
}
break;
}

var G__11718 = args11716.length;
switch (G__11718) {
case 1:
return schema.core.pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return schema.core.pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11716.length)].join('')));

}
});

schema.core.pred.cljs$core$IFn$_invoke$arity$1 = (function (p_QMARK_){
return schema.core.pred.call(null,p_QMARK_,cljs.core.symbol.call(null,schema.utils.fn_name.call(null,p_QMARK_)));
});

schema.core.pred.cljs$core$IFn$_invoke$arity$2 = (function (p_QMARK_,pred_name){
if(cljs.core.ifn_QMARK_.call(null,p_QMARK_)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not a function: %s",p_QMARK_)));
}

return (new schema.core.Predicate(p_QMARK_,pred_name,null,null,null));
});

schema.core.pred.cljs$lang$maxFixedArity = 2;

schema.core.protocol_name = (function schema$core$protocol_name(protocol){
return new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,protocol));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Protocol = (function (p,__meta,__extmap,__hash){
this.p = p;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Protocol.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11726,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11728 = (((k11726 instanceof cljs.core.Keyword))?k11726.fqn:null);
switch (G__11728) {
case "p":
return self__.p;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11726,else__7812__auto__);

}
});

schema.core.Protocol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Protocol{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Protocol.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11725){
var self__ = this;
var G__11725__$1 = this;
return (new cljs.core.RecordIter((0),G__11725__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Protocol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Protocol.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Protocol(self__.p,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Protocol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Protocol.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"p","p",151049309),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Protocol.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11725){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11729 = cljs.core.keyword_identical_QMARK_;
var expr__11730 = k__7817__auto__;
if(cljs.core.truth_(pred__11729.call(null,new cljs.core.Keyword(null,"p","p",151049309),expr__11730))){
return (new schema.core.Protocol(G__11725,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Protocol(self__.p,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11725),null));
}
});

schema.core.Protocol.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"p","p",151049309),self__.p],null))], null),self__.__extmap));
});

schema.core.Protocol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11725){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Protocol(self__.p,G__11725,self__.__extmap,self__.__hash));
});

schema.core.Protocol.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Protocol.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Protocol.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11723_SHARP_){
return new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)).call(null,p1__11723_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11724_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.protocol_name.call(null,this$__$1);
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11724_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"satisfies?","satisfies?",-433227199,null));
});})(this$__$1))
));
});

schema.core.Protocol.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.protocol_name.call(null,this$__$1);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"protocol","protocol",-2001965651,null));
});

schema.core.Protocol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null)], null);
});

schema.core.Protocol.cljs$lang$type = true;

schema.core.Protocol.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Protocol");
});

schema.core.Protocol.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Protocol");
});

schema.core.__GT_Protocol = (function schema$core$__GT_Protocol(p){
return (new schema.core.Protocol(p,null,null,null));
});

schema.core.map__GT_Protocol = (function schema$core$map__GT_Protocol(G__11727){
return (new schema.core.Protocol(new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(G__11727),null,cljs.core.dissoc.call(null,G__11727,new cljs.core.Keyword(null,"p","p",151049309)),null));
});

RegExp.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

RegExp.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,cljs.core.some_fn.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.string_QMARK_,((function (this$__$1){
return (function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"string?","string?",-1129175764,null));
});})(this$__$1))
),schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11733_SHARP_){
return cljs.core.re_find.call(null,this$__$1,p1__11733_SHARP_);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11734_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,this$__$1);
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11734_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"re-find","re-find",1143444147,null));
});})(this$__$1))
)));
});

RegExp.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("#\""),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)].join('').slice((1),(-1))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\"")].join(''));
});
/**
 * Satisfied only by String.
 * Is (pred string?) and not js/String in cljs because of keywords.
 */
schema.core.Str = schema.core.pred.call(null,cljs.core.string_QMARK_);
/**
 * Boolean true or false
 */
schema.core.Bool = Boolean;
/**
 * Any number
 */
schema.core.Num = Number;
/**
 * Any integral number
 */
schema.core.Int = schema.core.pred.call(null,cljs.core.integer_QMARK_);
/**
 * A keyword
 */
schema.core.Keyword = schema.core.pred.call(null,cljs.core.keyword_QMARK_);
/**
 * A symbol
 */
schema.core.Symbol = schema.core.pred.call(null,cljs.core.symbol_QMARK_);
/**
 * A regular expression
 */
schema.core.Regex = (function (){
if(typeof schema.core.t_schema$core11737 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {schema.core.Schema}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
schema.core.t_schema$core11737 = (function (meta11738){
this.meta11738 = meta11738;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
schema.core.t_schema$core11737.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11739,meta11738__$1){
var self__ = this;
var _11739__$1 = this;
return (new schema.core.t_schema$core11737(meta11738__$1));
});

schema.core.t_schema$core11737.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11739){
var self__ = this;
var _11739__$1 = this;
return self__.meta11738;
});

schema.core.t_schema$core11737.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.t_schema$core11737.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__11735_SHARP_){
return (p1__11735_SHARP_ instanceof RegExp);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__11736_SHARP_){
return cljs.core._conj.call(null,cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__11736_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol("js","RegExp","js/RegExp",1778210562,null)),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
));
});

schema.core.t_schema$core11737.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Symbol(null,"Regex","Regex",205914413,null);
});

schema.core.t_schema$core11737.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta11738","meta11738",-914235754,null)], null);
});

schema.core.t_schema$core11737.cljs$lang$type = true;

schema.core.t_schema$core11737.cljs$lang$ctorStr = "schema.core/t_schema$core11737";

schema.core.t_schema$core11737.cljs$lang$ctorPrWriter = (function (this__7793__auto__,writer__7794__auto__,opt__7795__auto__){
return cljs.core._write.call(null,writer__7794__auto__,"schema.core/t_schema$core11737");
});

schema.core.__GT_t_schema$core11737 = (function schema$core$__GT_t_schema$core11737(meta11738){
return (new schema.core.t_schema$core11737(meta11738));
});

}

return (new schema.core.t_schema$core11737(cljs.core.PersistentArrayMap.EMPTY));
})()
;
/**
 * The local representation of #inst ...
 */
schema.core.Inst = Date;
/**
 * The local representation of #uuid ...
 */
schema.core.Uuid = cljs.core.UUID;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Maybe = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Maybe.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11741,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11743 = (((k11741 instanceof cljs.core.Keyword))?k11741.fqn:null);
switch (G__11743) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11741,else__7812__auto__);

}
});

schema.core.Maybe.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Maybe{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Maybe.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11740){
var self__ = this;
var G__11740__$1 = this;
return (new cljs.core.RecordIter((0),G__11740__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Maybe.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Maybe.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Maybe.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Maybe.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Maybe.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11740){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11744 = cljs.core.keyword_identical_QMARK_;
var expr__11745 = k__7817__auto__;
if(cljs.core.truth_(pred__11744.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__11745))){
return (new schema.core.Maybe(G__11740,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Maybe(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11740),null));
}
});

schema.core.Maybe.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Maybe.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11740){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Maybe(self__.schema,G__11740,self__.__extmap,self__.__hash));
});

schema.core.Maybe.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Maybe.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Maybe.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.nil_QMARK_,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema.core.eq.call(null,null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema], null)], null));
});

schema.core.Maybe.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"maybe","maybe",1326133967,null));
});

schema.core.Maybe.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Maybe.cljs$lang$type = true;

schema.core.Maybe.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Maybe");
});

schema.core.Maybe.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Maybe");
});

schema.core.__GT_Maybe = (function schema$core$__GT_Maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

schema.core.map__GT_Maybe = (function schema$core$map__GT_Maybe(G__11742){
return (new schema.core.Maybe(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__11742),null,cljs.core.dissoc.call(null,G__11742,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * A value that must either be nil or satisfy schema
 */
schema.core.maybe = (function schema$core$maybe(schema__$1){
return (new schema.core.Maybe(schema__$1,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.NamedSchema = (function (schema,name,__meta,__extmap,__hash){
this.schema = schema;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.NamedSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11750,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11752 = (((k11750 instanceof cljs.core.Keyword))?k11750.fqn:null);
switch (G__11752) {
case "schema":
return self__.schema;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11750,else__7812__auto__);

}
});

schema.core.NamedSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.NamedSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.NamedSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11749){
var self__ = this;
var G__11749__$1 = this;
return (new cljs.core.RecordIter((0),G__11749__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.NamedSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.NamedSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.NamedSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.NamedSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.NamedSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11749){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11753 = cljs.core.keyword_identical_QMARK_;
var expr__11754 = k__7817__auto__;
if(cljs.core.truth_(pred__11753.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__11754))){
return (new schema.core.NamedSchema(G__11749,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11753.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__11754))){
return (new schema.core.NamedSchema(self__.schema,G__11749,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.NamedSchema(self__.schema,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11749),null));
}
}
});

schema.core.NamedSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.NamedSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11749){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.NamedSchema(self__.schema,self__.name,G__11749,self__.__extmap,self__.__hash));
});

schema.core.NamedSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.NamedSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.NamedSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,new cljs.core.Keyword(null,"wrap-error","wrap-error",536732809),((function (this$__$1){
return (function (p1__11748_SHARP_){
return schema.utils.__GT_NamedError.call(null,self__.name,p1__11748_SHARP_);
});})(this$__$1))
], null)], null));
});

schema.core.NamedSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = self__.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"named","named",1218138048,null));
});

schema.core.NamedSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.NamedSchema.cljs$lang$type = true;

schema.core.NamedSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/NamedSchema");
});

schema.core.NamedSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/NamedSchema");
});

schema.core.__GT_NamedSchema = (function schema$core$__GT_NamedSchema(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

schema.core.map__GT_NamedSchema = (function schema$core$map__GT_NamedSchema(G__11751){
return (new schema.core.NamedSchema(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__11751),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__11751),null,cljs.core.dissoc.call(null,G__11751,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A value that must satisfy schema, and has a name for documentation purposes.
 */
schema.core.named = (function schema$core$named(schema__$1,name){
return (new schema.core.NamedSchema(schema__$1,name,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Either = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Either.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11759,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11761 = (((k11759 instanceof cljs.core.Keyword))?k11759.fqn:null);
switch (G__11761) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11759,else__7812__auto__);

}
});

schema.core.Either.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Either{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Either.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11758){
var self__ = this;
var G__11758__$1 = this;
return (new cljs.core.RecordIter((0),G__11758__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Either.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Either.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Either(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Either.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Either.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Either.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11758){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11762 = cljs.core.keyword_identical_QMARK_;
var expr__11763 = k__7817__auto__;
if(cljs.core.truth_(pred__11762.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__11763))){
return (new schema.core.Either(G__11758,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Either(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11758),null));
}
});

schema.core.Either.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Either.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11758){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Either(self__.schemas,G__11758,self__.__extmap,self__.__hash));
});

schema.core.Either.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Either.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Either.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__7970__auto__ = ((function (this$__$1){
return (function schema$core$iter__11765(s__11766){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__11766__$1 = s__11766;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11766__$1);
if(temp__4657__auto__){
var s__11766__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11766__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11766__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11768 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11767 = (0);
while(true){
if((i__11767 < size__7969__auto__)){
var s = cljs.core._nth.call(null,c__7968__auto__,i__11767);
cljs.core.chunk_append.call(null,b__11768,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__11770 = (i__11767 + (1));
i__11767 = G__11770;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11768),schema$core$iter__11765.call(null,cljs.core.chunk_rest.call(null,s__11766__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11768),null);
}
} else {
var s = cljs.core.first.call(null,s__11766__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),cljs.core.complement.call(null,schema.core.checker.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__11765.call(null,cljs.core.rest.call(null,s__11766__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__7970__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__11757_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__11757_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"some-matching-either-clause?","some-matching-either-clause?",-1443305015,null));
});})(this$__$1))
);
});

schema.core.Either.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"either","either",-2144373018,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Either.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Either.cljs$lang$type = true;

schema.core.Either.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Either");
});

schema.core.Either.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Either");
});

schema.core.__GT_Either = (function schema$core$__GT_Either(schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.map__GT_Either = (function schema$core$map__GT_Either(G__11760){
return (new schema.core.Either(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__11760),null,cljs.core.dissoc.call(null,G__11760,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy at least one schema in schemas.
 * Note that `either` does not work properly with coercion
 * 
 * DEPRECATED: prefer `conditional` or `cond-pre`
 * 
 * WARNING: either does not work with coercion.  It is also slow and gives
 * bad error messages.  Please consider using `conditional` and friends
 * instead; they are more efficient, provide better error messages,
 * and work with coercion.
 */
schema.core.either = (function schema$core$either(var_args){
var args__8302__auto__ = [];
var len__8295__auto___11772 = arguments.length;
var i__8296__auto___11773 = (0);
while(true){
if((i__8296__auto___11773 < len__8295__auto___11772)){
args__8302__auto__.push((arguments[i__8296__auto___11773]));

var G__11774 = (i__8296__auto___11773 + (1));
i__8296__auto___11773 = G__11774;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

schema.core.either.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Either(schemas,null,null,null));
});

schema.core.either.cljs$lang$maxFixedArity = (0);

schema.core.either.cljs$lang$applyTo = (function (seq11771){
return schema.core.either.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11771));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.ConditionalSchema = (function (preds_and_schemas,error_symbol,__meta,__extmap,__hash){
this.preds_and_schemas = preds_and_schemas;
this.error_symbol = error_symbol;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.ConditionalSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11777,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11779 = (((k11777 instanceof cljs.core.Keyword))?k11777.fqn:null);
switch (G__11779) {
case "preds-and-schemas":
return self__.preds_and_schemas;

break;
case "error-symbol":
return self__.error_symbol;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11777,else__7812__auto__);

}
});

schema.core.ConditionalSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.ConditionalSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.ConditionalSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11776){
var self__ = this;
var G__11776__$1 = this;
return (new cljs.core.RecordIter((0),G__11776__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.ConditionalSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.ConditionalSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.ConditionalSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11776){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11780 = cljs.core.keyword_identical_QMARK_;
var expr__11781 = k__7817__auto__;
if(cljs.core.truth_(pred__11780.call(null,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),expr__11781))){
return (new schema.core.ConditionalSchema(G__11776,self__.error_symbol,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11780.call(null,new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),expr__11781))){
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,G__11776,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11776),null));
}
}
});

schema.core.ConditionalSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),self__.preds_and_schemas],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428),self__.error_symbol],null))], null),self__.__extmap));
});

schema.core.ConditionalSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11776){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.ConditionalSchema(self__.preds_and_schemas,self__.error_symbol,G__11776,self__.__extmap,self__.__hash));
});

schema.core.ConditionalSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.ConditionalSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__7970__auto__ = ((function (this$__$1){
return (function schema$core$iter__11783(s__11784){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__11784__$1 = s__11784;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11784__$1);
if(temp__4657__auto__){
var s__11784__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11784__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11784__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11786 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11785 = (0);
while(true){
if((i__11785 < size__7969__auto__)){
var vec__11793 = cljs.core._nth.call(null,c__7968__auto__,i__11785);
var p = cljs.core.nth.call(null,vec__11793,(0),null);
var s = cljs.core.nth.call(null,vec__11793,(1),null);
cljs.core.chunk_append.call(null,b__11786,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__11804 = (i__11785 + (1));
i__11785 = G__11804;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11786),schema$core$iter__11783.call(null,cljs.core.chunk_rest.call(null,s__11784__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11786),null);
}
} else {
var vec__11796 = cljs.core.first.call(null,s__11784__$2);
var p = cljs.core.nth.call(null,vec__11796,(0),null);
var s = cljs.core.nth.call(null,vec__11796,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),p,new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__11783.call(null,cljs.core.rest.call(null,s__11784__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__7970__auto__.call(null,self__.preds_and_schemas);
})(),((function (this$__$1){
return (function (p1__11775_SHARP_){
var x__8024__auto__ = (function (){var or__7182__auto__ = self__.error_symbol;
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,self__.preds_and_schemas))){
return cljs.core.symbol.call(null,schema.utils.fn_name.call(null,cljs.core.ffirst.call(null,self__.preds_and_schemas)));
} else {
return new cljs.core.Symbol(null,"some-matching-condition?","some-matching-condition?",1512398506,null);
}
}
})();
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11775_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
});})(this$__$1))
);
});

schema.core.ConditionalSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"conditional","conditional",-1212542970,null),cljs.core.concat.call(null,cljs.core.mapcat.call(null,((function (this$__$1){
return (function (p__11799){
var vec__11800 = p__11799;
var pred = cljs.core.nth.call(null,vec__11800,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__11800,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,schema.utils.fn_name.call(null,pred)),schema.core.explain.call(null,schema__$1)], null);
});})(this$__$1))
,self__.preds_and_schemas),(cljs.core.truth_(self__.error_symbol)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.error_symbol], null):null)));
});

schema.core.ConditionalSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"preds-and-schemas","preds-and-schemas",333765172,null),new cljs.core.Symbol(null,"error-symbol","error-symbol",817051099,null)], null);
});

schema.core.ConditionalSchema.cljs$lang$type = true;

schema.core.ConditionalSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/ConditionalSchema");
});

schema.core.ConditionalSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/ConditionalSchema");
});

schema.core.__GT_ConditionalSchema = (function schema$core$__GT_ConditionalSchema(preds_and_schemas,error_symbol){
return (new schema.core.ConditionalSchema(preds_and_schemas,error_symbol,null,null,null));
});

schema.core.map__GT_ConditionalSchema = (function schema$core$map__GT_ConditionalSchema(G__11778){
return (new schema.core.ConditionalSchema(new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355).cljs$core$IFn$_invoke$arity$1(G__11778),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428).cljs$core$IFn$_invoke$arity$1(G__11778),null,cljs.core.dissoc.call(null,G__11778,new cljs.core.Keyword(null,"preds-and-schemas","preds-and-schemas",-1306766355),new cljs.core.Keyword(null,"error-symbol","error-symbol",-823480428)),null));
});

/**
 * Define a conditional schema.  Takes args like cond,
 * (conditional pred1 schema1 pred2 schema2 ...),
 * and checks the first schemaX where predX (an ordinary Clojure function
 * that returns true or false) returns true on the value.
 * Unlike cond, throws if the value does not match any condition.
 * :else may be used as a final condition in the place of (constantly true).
 * More efficient than either, since only one schema must be checked.
 * An optional final argument can be passed, a symbol to appear in
 * error messages when none of the conditions match.
 */
schema.core.conditional = (function schema$core$conditional(var_args){
var args__8302__auto__ = [];
var len__8295__auto___11822 = arguments.length;
var i__8296__auto___11823 = (0);
while(true){
if((i__8296__auto___11823 < len__8295__auto___11822)){
args__8302__auto__.push((arguments[i__8296__auto___11823]));

var G__11824 = (i__8296__auto___11823 + (1));
i__8296__auto___11823 = G__11824;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic = (function (preds_and_schemas){
if((cljs.core.seq.call(null,preds_and_schemas)) && ((cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas))) || ((cljs.core.last.call(null,preds_and_schemas) instanceof cljs.core.Symbol)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected even, nonzero number of args (with optional trailing symbol); got %s",cljs.core.count.call(null,preds_and_schemas))));
}

return (new schema.core.ConditionalSchema(cljs.core.vec.call(null,(function (){var iter__7970__auto__ = (function schema$core$iter__11806(s__11807){
return (new cljs.core.LazySeq(null,(function (){
var s__11807__$1 = s__11807;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11807__$1);
if(temp__4657__auto__){
var s__11807__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11807__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11807__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11809 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11808 = (0);
while(true){
if((i__11808 < size__7969__auto__)){
var vec__11816 = cljs.core._nth.call(null,c__7968__auto__,i__11808);
var pred = cljs.core.nth.call(null,vec__11816,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__11816,(1),null);
cljs.core.chunk_append.call(null,b__11809,(function (){
if(cljs.core.ifn_QMARK_.call(null,pred)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Conditional predicate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" must be a function")].join(''))));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null);
})()
);

var G__11825 = (i__11808 + (1));
i__11808 = G__11825;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11809),schema$core$iter__11806.call(null,cljs.core.chunk_rest.call(null,s__11807__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11809),null);
}
} else {
var vec__11819 = cljs.core.first.call(null,s__11807__$2);
var pred = cljs.core.nth.call(null,vec__11819,(0),null);
var schema__$1 = cljs.core.nth.call(null,vec__11819,(1),null);
return cljs.core.cons.call(null,(function (){
if(cljs.core.ifn_QMARK_.call(null,pred)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Conditional predicate "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" must be a function")].join(''))));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core._EQ_.call(null,pred,new cljs.core.Keyword(null,"else","else",-1508377146)))?cljs.core.constantly.call(null,true):pred),schema__$1], null);
})()
,schema$core$iter__11806.call(null,cljs.core.rest.call(null,s__11807__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7970__auto__.call(null,cljs.core.partition.call(null,(2),preds_and_schemas));
})()),((cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,preds_and_schemas)))?cljs.core.last.call(null,preds_and_schemas):null),null,null,null));
});

schema.core.conditional.cljs$lang$maxFixedArity = (0);

schema.core.conditional.cljs$lang$applyTo = (function (seq11805){
return schema.core.conditional.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11805));
});


/**
 * @interface
 */
schema.core.HasPrecondition = function(){};

/**
 * Return a predicate representing the Precondition for this schema:
 *   the predicate returns true if the precondition is satisfied.
 *   (See spec.core for more details)
 */
schema.core.precondition = (function schema$core$precondition(this$){
if((!((this$ == null))) && (!((this$.schema$core$HasPrecondition$precondition$arity$1 == null)))){
return this$.schema$core$HasPrecondition$precondition$arity$1(this$);
} else {
var x__7850__auto__ = (((this$ == null))?null:this$);
var m__7851__auto__ = (schema.core.precondition[goog.typeOf(x__7850__auto__)]);
if(!((m__7851__auto__ == null))){
return m__7851__auto__.call(null,this$);
} else {
var m__7851__auto____$1 = (schema.core.precondition["_"]);
if(!((m__7851__auto____$1 == null))){
return m__7851__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"HasPrecondition.precondition",this$);
}
}
}
});

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.leaf.LeafSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.variant.VariantSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.every_pred.call(null,cljs.core.complement.call(null,this$__$1.pre),cljs.core.apply.call(null,cljs.core.some_fn,(function (){var iter__7970__auto__ = ((function (this$__$1){
return (function schema$core$iter__11826(s__11827){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__11827__$1 = s__11827;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11827__$1);
if(temp__4657__auto__){
var s__11827__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11827__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11827__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11829 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11828 = (0);
while(true){
if((i__11828 < size__7969__auto__)){
var map__11834 = cljs.core._nth.call(null,c__7968__auto__,i__11828);
var map__11834__$1 = ((((!((map__11834 == null)))?((((map__11834.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11834.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11834):map__11834);
var guard = cljs.core.get.call(null,map__11834__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__11834__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
cljs.core.chunk_append.call(null,b__11829,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))));

var G__11838 = (i__11828 + (1));
i__11828 = G__11838;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11829),schema$core$iter__11826.call(null,cljs.core.chunk_rest.call(null,s__11827__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11829),null);
}
} else {
var map__11836 = cljs.core.first.call(null,s__11827__$2);
var map__11836__$1 = ((((!((map__11836 == null)))?((((map__11836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11836.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11836):map__11836);
var guard = cljs.core.get.call(null,map__11836__$1,new cljs.core.Keyword(null,"guard","guard",-873147811));
var schema__$1 = cljs.core.get.call(null,map__11836__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
return cljs.core.cons.call(null,(cljs.core.truth_(guard)?cljs.core.every_pred.call(null,guard,schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))):schema.core.precondition.call(null,schema.core.spec.call(null,schema__$1))),schema$core$iter__11826.call(null,cljs.core.rest.call(null,s__11827__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__7970__auto__.call(null,this$__$1.options);
})()));
});

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.spec.collection.CollectionSpec.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.complement.call(null,this$__$1.pre);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.CondPre = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.CondPre.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11841,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11843 = (((k11841 instanceof cljs.core.Keyword))?k11841.fqn:null);
switch (G__11843) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11841,else__7812__auto__);

}
});

schema.core.CondPre.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.CondPre{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.CondPre.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11840){
var self__ = this;
var G__11840__$1 = this;
return (new cljs.core.RecordIter((0),G__11840__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.CondPre.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.CondPre.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.CondPre.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.CondPre.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.CondPre.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11840){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11844 = cljs.core.keyword_identical_QMARK_;
var expr__11845 = k__7817__auto__;
if(cljs.core.truth_(pred__11844.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__11845))){
return (new schema.core.CondPre(G__11840,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.CondPre(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11840),null));
}
});

schema.core.CondPre.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.CondPre.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11840){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.CondPre(self__.schemas,G__11840,self__.__extmap,self__.__hash));
});

schema.core.CondPre.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.CondPre.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.CondPre.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,(function (){var iter__7970__auto__ = ((function (this$__$1){
return (function schema$core$iter__11847(s__11848){
return (new cljs.core.LazySeq(null,((function (this$__$1){
return (function (){
var s__11848__$1 = s__11848;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11848__$1);
if(temp__4657__auto__){
var s__11848__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11848__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11848__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11850 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11849 = (0);
while(true){
if((i__11849 < size__7969__auto__)){
var s = cljs.core._nth.call(null,c__7968__auto__,i__11849);
cljs.core.chunk_append.call(null,b__11850,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null));

var G__11852 = (i__11849 + (1));
i__11849 = G__11852;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11850),schema$core$iter__11847.call(null,cljs.core.chunk_rest.call(null,s__11848__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11850),null);
}
} else {
var s = cljs.core.first.call(null,s__11848__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"guard","guard",-873147811),schema.core.precondition.call(null,schema.core.spec.call(null,s)),new cljs.core.Keyword(null,"schema","schema",-1582001791),s], null),schema$core$iter__11847.call(null,cljs.core.rest.call(null,s__11848__$2)));
}
} else {
return null;
}
break;
}
});})(this$__$1))
,null,null));
});})(this$__$1))
;
return iter__7970__auto__.call(null,self__.schemas);
})(),((function (this$__$1){
return (function (p1__11839_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__11839_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"matches-some-precondition?","matches-some-precondition?",2123072832,null));
});})(this$__$1))
);
});

schema.core.CondPre.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"cond-pre","cond-pre",-923707731,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.CondPre.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.CondPre.cljs$lang$type = true;

schema.core.CondPre.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/CondPre");
});

schema.core.CondPre.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/CondPre");
});

schema.core.__GT_CondPre = (function schema$core$__GT_CondPre(schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.map__GT_CondPre = (function schema$core$map__GT_CondPre(G__11842){
return (new schema.core.CondPre(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__11842),null,cljs.core.dissoc.call(null,G__11842,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A replacement for `either` that constructs a conditional schema
 * based on the schema spec preconditions of the component schemas.
 * 
 * Given a datum, the preconditions for each schema (which typically
 * check just the outermost class) are tested against the datum in turn.
 * The first schema whose precondition matches is greedily selected,
 * and the datum is validated against that schema.  Unlike `either`,
 * a validation failure is final (and there is no backtracking to try
 * other schemas that might match).
 * 
 * Thus, `cond-pre` is only suitable for schemas with mutually exclusive
 * preconditions (e.g., s/Int and s/Str).  If this doesn't hold
 * (e.g. {:a s/Int} and {:b s/Str}), you must use `conditional` instead
 * and provide an explicit condition for distinguishing the cases.
 * 
 * EXPERIMENTAL
 */
schema.core.cond_pre = (function schema$core$cond_pre(var_args){
var args__8302__auto__ = [];
var len__8295__auto___11854 = arguments.length;
var i__8296__auto___11855 = (0);
while(true){
if((i__8296__auto___11855 < len__8295__auto___11854)){
args__8302__auto__.push((arguments[i__8296__auto___11855]));

var G__11856 = (i__8296__auto___11855 + (1));
i__8296__auto___11855 = G__11856;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.CondPre(schemas,null,null,null));
});

schema.core.cond_pre.cljs$lang$maxFixedArity = (0);

schema.core.cond_pre.cljs$lang$applyTo = (function (seq11853){
return schema.core.cond_pre.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11853));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Constrained = (function (schema,postcondition,post_name,__meta,__extmap,__hash){
this.schema = schema;
this.postcondition = postcondition;
this.post_name = post_name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Constrained.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Constrained.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11859,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11861 = (((k11859 instanceof cljs.core.Keyword))?k11859.fqn:null);
switch (G__11861) {
case "schema":
return self__.schema;

break;
case "postcondition":
return self__.postcondition;

break;
case "post-name":
return self__.post_name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11859,else__7812__auto__);

}
});

schema.core.Constrained.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Constrained{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),self__.postcondition],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post-name","post-name",491455269),self__.post_name],null))], null),self__.__extmap));
});

schema.core.Constrained.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Constrained.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11858){
var self__ = this;
var G__11858__$1 = this;
return (new cljs.core.RecordIter((0),G__11858__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),new cljs.core.Keyword(null,"post-name","post-name",491455269)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Constrained.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Constrained.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Constrained(self__.schema,self__.postcondition,self__.post_name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Constrained.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Constrained.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Constrained.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Constrained.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"post-name","post-name",491455269),null,new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Constrained(self__.schema,self__.postcondition,self__.post_name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Constrained.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11858){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11862 = cljs.core.keyword_identical_QMARK_;
var expr__11863 = k__7817__auto__;
if(cljs.core.truth_(pred__11862.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__11863))){
return (new schema.core.Constrained(G__11858,self__.postcondition,self__.post_name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11862.call(null,new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),expr__11863))){
return (new schema.core.Constrained(self__.schema,G__11858,self__.post_name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11862.call(null,new cljs.core.Keyword(null,"post-name","post-name",491455269),expr__11863))){
return (new schema.core.Constrained(self__.schema,self__.postcondition,G__11858,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Constrained(self__.schema,self__.postcondition,self__.post_name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11858),null));
}
}
}
});

schema.core.Constrained.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),self__.postcondition],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post-name","post-name",491455269),self__.post_name],null))], null),self__.__extmap));
});

schema.core.Constrained.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11858){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Constrained(self__.schema,self__.postcondition,self__.post_name,G__11858,self__.__extmap,self__.__hash));
});

schema.core.Constrained.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Constrained.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Constrained.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema], null)], null),null,schema.spec.core.precondition.call(null,this$__$1,self__.postcondition,((function (this$__$1){
return (function (p1__11857_SHARP_){
var x__8024__auto__ = self__.post_name;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__11857_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
});})(this$__$1))
));
});

schema.core.Constrained.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = self__.post_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"constrained","constrained",-2057147788,null));
});

schema.core.Constrained.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"postcondition","postcondition",903430305,null),new cljs.core.Symbol(null,"post-name","post-name",2131986796,null)], null);
});

schema.core.Constrained.cljs$lang$type = true;

schema.core.Constrained.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Constrained");
});

schema.core.Constrained.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Constrained");
});

schema.core.__GT_Constrained = (function schema$core$__GT_Constrained(schema__$1,postcondition,post_name){
return (new schema.core.Constrained(schema__$1,postcondition,post_name,null,null,null));
});

schema.core.map__GT_Constrained = (function schema$core$map__GT_Constrained(G__11860){
return (new schema.core.Constrained(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__11860),new cljs.core.Keyword(null,"postcondition","postcondition",-737101222).cljs$core$IFn$_invoke$arity$1(G__11860),new cljs.core.Keyword(null,"post-name","post-name",491455269).cljs$core$IFn$_invoke$arity$1(G__11860),null,cljs.core.dissoc.call(null,G__11860,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"postcondition","postcondition",-737101222),new cljs.core.Keyword(null,"post-name","post-name",491455269)),null));
});

/**
 * A schema with an additional post-condition.  Differs from `conditional`
 * with a single schema, in that the predicate checked *after* the main
 * schema.  This can lead to better error messages, and is often better
 * suited for coercion.
 */
schema.core.constrained = (function schema$core$constrained(var_args){
var args11866 = [];
var len__8295__auto___11869 = arguments.length;
var i__8296__auto___11870 = (0);
while(true){
if((i__8296__auto___11870 < len__8295__auto___11869)){
args11866.push((arguments[i__8296__auto___11870]));

var G__11871 = (i__8296__auto___11870 + (1));
i__8296__auto___11870 = G__11871;
continue;
} else {
}
break;
}

var G__11868 = args11866.length;
switch (G__11868) {
case 2:
return schema.core.constrained.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return schema.core.constrained.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11866.length)].join('')));

}
});

schema.core.constrained.cljs$core$IFn$_invoke$arity$2 = (function (s,p_QMARK_){
return schema.core.constrained.call(null,s,p_QMARK_,cljs.core.symbol.call(null,schema.utils.fn_name.call(null,p_QMARK_)));
});

schema.core.constrained.cljs$core$IFn$_invoke$arity$3 = (function (s,p_QMARK_,pred_name){
if(cljs.core.ifn_QMARK_.call(null,p_QMARK_)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not a function: %s",p_QMARK_)));
}

return (new schema.core.Constrained(s,p_QMARK_,pred_name,null,null,null));
});

schema.core.constrained.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {schema.core.HasPrecondition}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {schema.spec.core.CoreSpec}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Both = (function (schemas,__meta,__extmap,__hash){
this.schemas = schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Both.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11875,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11877 = (((k11875 instanceof cljs.core.Keyword))?k11875.fqn:null);
switch (G__11877) {
case "schemas":
return self__.schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11875,else__7812__auto__);

}
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$spec$core$CoreSpec$subschemas$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.schemas;
});

schema.core.Both.prototype.schema$spec$core$CoreSpec$checker$arity$2 = (function (this$,params){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.call(null,((function (this$__$1){
return (function (f,t){
return ((function (this$__$1){
return (function (x){
var tx = t.call(null,x);
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,tx))){
return tx;
} else {
return f.call(null,(function (){var or__7182__auto__ = tx;
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return x;
}
})());
}
});
;})(this$__$1))
});})(this$__$1))
,cljs.core.map.call(null,((function (this$__$1){
return (function (p1__11873_SHARP_){
return schema.spec.core.sub_checker.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),p1__11873_SHARP_], null),params);
});})(this$__$1))
,cljs.core.reverse.call(null,self__.schemas)));
});

schema.core.Both.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Both{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11874){
var self__ = this;
var G__11874__$1 = this;
return (new cljs.core.RecordIter((0),G__11874__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schemas","schemas",575070579)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Both.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Both.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Both(self__.schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Both.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Both.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schemas","schemas",575070579),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Both.prototype.schema$core$HasPrecondition$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$core$HasPrecondition$precondition$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.call(null,cljs.core.every_pred,cljs.core.map.call(null,cljs.core.comp.call(null,schema.core.precondition,schema.core.spec),self__.schemas));
});

schema.core.Both.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11874){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11878 = cljs.core.keyword_identical_QMARK_;
var expr__11879 = k__7817__auto__;
if(cljs.core.truth_(pred__11878.call(null,new cljs.core.Keyword(null,"schemas","schemas",575070579),expr__11879))){
return (new schema.core.Both(G__11874,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Both(self__.schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11874),null));
}
});

schema.core.Both.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schemas","schemas",575070579),self__.schemas],null))], null),self__.__extmap));
});

schema.core.Both.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11874){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Both(self__.schemas,G__11874,self__.__extmap,self__.__hash));
});

schema.core.Both.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Both.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Both.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

schema.core.Both.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons.call(null,new cljs.core.Symbol(null,"both","both",1246882687,null),cljs.core.map.call(null,schema.core.explain,self__.schemas));
});

schema.core.Both.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schemas","schemas",-2079365190,null)], null);
});

schema.core.Both.cljs$lang$type = true;

schema.core.Both.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Both");
});

schema.core.Both.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Both");
});

schema.core.__GT_Both = (function schema$core$__GT_Both(schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.map__GT_Both = (function schema$core$map__GT_Both(G__11876){
return (new schema.core.Both(new cljs.core.Keyword(null,"schemas","schemas",575070579).cljs$core$IFn$_invoke$arity$1(G__11876),null,cljs.core.dissoc.call(null,G__11876,new cljs.core.Keyword(null,"schemas","schemas",575070579)),null));
});

/**
 * A value that must satisfy every schema in schemas.
 * 
 * DEPRECATED: prefer 'conditional' with a single condition
 * instead, or `constrained`.
 * 
 * When used with coercion, coerces each schema in sequence.
 */
schema.core.both = (function schema$core$both(var_args){
var args__8302__auto__ = [];
var len__8295__auto___11883 = arguments.length;
var i__8296__auto___11884 = (0);
while(true){
if((i__8296__auto___11884 < len__8295__auto___11883)){
args__8302__auto__.push((arguments[i__8296__auto___11884]));

var G__11885 = (i__8296__auto___11884 + (1));
i__8296__auto___11884 = G__11885;
continue;
} else {
}
break;
}

var argseq__8303__auto__ = ((((0) < args__8302__auto__.length))?(new cljs.core.IndexedSeq(args__8302__auto__.slice((0)),(0),null)):null);
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(argseq__8303__auto__);
});

schema.core.both.cljs$core$IFn$_invoke$arity$variadic = (function (schemas){
return (new schema.core.Both(schemas,null,null,null));
});

schema.core.both.cljs$lang$maxFixedArity = (0);

schema.core.both.cljs$lang$applyTo = (function (seq11882){
return schema.core.both.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq11882));
});

/**
 * if the predicate returns truthy, use the if-schema, otherwise use the else-schema
 */
schema.core.if$ = (function schema$core$if(pred,if_schema,else_schema){
return schema.core.conditional.call(null,pred,if_schema,cljs.core.constantly.call(null,true),else_schema);
});
schema.core.var_name = (function schema$core$var_name(v){
var map__11888 = cljs.core.meta.call(null,v);
var map__11888__$1 = ((((!((map__11888 == null)))?((((map__11888.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11888.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11888):map__11888);
var ns = cljs.core.get.call(null,map__11888__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var name = cljs.core.get.call(null,map__11888__$1,new cljs.core.Keyword(null,"name","name",1843675177));
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Recursive = (function (derefable,__meta,__extmap,__hash){
this.derefable = derefable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Recursive.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11891,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11893 = (((k11891 instanceof cljs.core.Keyword))?k11891.fqn:null);
switch (G__11893) {
case "derefable":
return self__.derefable;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11891,else__7812__auto__);

}
});

schema.core.Recursive.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Recursive{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Recursive.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11890){
var self__ = this;
var G__11890__$1 = this;
return (new cljs.core.RecordIter((0),G__11890__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"derefable","derefable",377265868)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Recursive.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Recursive.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Recursive.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Recursive.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"derefable","derefable",377265868),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Recursive.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11890){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11894 = cljs.core.keyword_identical_QMARK_;
var expr__11895 = k__7817__auto__;
if(cljs.core.truth_(pred__11894.call(null,new cljs.core.Keyword(null,"derefable","derefable",377265868),expr__11895))){
return (new schema.core.Recursive(G__11890,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Recursive(self__.derefable,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11890),null));
}
});

schema.core.Recursive.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"derefable","derefable",377265868),self__.derefable],null))], null),self__.__extmap));
});

schema.core.Recursive.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11890){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Recursive(self__.derefable,G__11890,self__.__extmap,self__.__hash));
});

schema.core.Recursive.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Recursive.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Recursive.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.variant.variant_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),cljs.core.deref.call(null,self__.derefable)], null)], null));
});

schema.core.Recursive.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = (((self__.derefable instanceof cljs.core.Var))?cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.var_name.call(null,self__.derefable);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"var","var",870848730,null)):new cljs.core.Symbol(null,"...","...",-1926939749,null));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"recursive","recursive",-1935549897,null));
});

schema.core.Recursive.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"derefable","derefable",2017797395,null)], null);
});

schema.core.Recursive.cljs$lang$type = true;

schema.core.Recursive.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Recursive");
});

schema.core.Recursive.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Recursive");
});

schema.core.__GT_Recursive = (function schema$core$__GT_Recursive(derefable){
return (new schema.core.Recursive(derefable,null,null,null));
});

schema.core.map__GT_Recursive = (function schema$core$map__GT_Recursive(G__11892){
return (new schema.core.Recursive(new cljs.core.Keyword(null,"derefable","derefable",377265868).cljs$core$IFn$_invoke$arity$1(G__11892),null,cljs.core.dissoc.call(null,G__11892,new cljs.core.Keyword(null,"derefable","derefable",377265868)),null));
});

/**
 * Support for (mutually) recursive schemas by passing a var that points to a schema,
 * e.g (recursive #'ExampleRecursiveSchema).
 */
schema.core.recursive = (function schema$core$recursive(schema__$1){
if(((!((schema__$1 == null)))?((((schema__$1.cljs$lang$protocol_mask$partition0$ & (32768))) || ((cljs.core.PROTOCOL_SENTINEL === schema__$1.cljs$core$IDeref$)))?true:(((!schema__$1.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,schema__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Not an IDeref: %s",schema__$1)));
}

return (new schema.core.Recursive(schema__$1,null,null,null));
});
schema.core.atom_QMARK_ = (function schema$core$atom_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAtom$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IAtom,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IAtom,x);
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Atomic = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Atomic.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Atomic.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11903,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11905 = (((k11903 instanceof cljs.core.Keyword))?k11903.fqn:null);
switch (G__11905) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11903,else__7812__auto__);

}
});

schema.core.Atomic.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Atomic{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Atomic.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Atomic.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11902){
var self__ = this;
var G__11902__$1 = this;
return (new cljs.core.RecordIter((0),G__11902__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Atomic.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Atomic.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Atomic(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Atomic.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Atomic.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Atomic.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Atomic.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Atomic(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Atomic.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11902){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11906 = cljs.core.keyword_identical_QMARK_;
var expr__11907 = k__7817__auto__;
if(cljs.core.truth_(pred__11906.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__11907))){
return (new schema.core.Atomic(G__11902,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Atomic(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11902),null));
}
});

schema.core.Atomic.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Atomic.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11902){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Atomic(self__.schema,G__11902,self__.__extmap,self__.__hash));
});

schema.core.Atomic.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Atomic.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Atomic.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,schema.core.atom_QMARK_,((function (this$__$1){
return (function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"atom?","atom?",-1007535292,null));
});})(this$__$1))
),cljs.core.atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.one_element.call(null,true,self__.schema,((function (this$__$1){
return (function (item_fn,coll){
item_fn.call(null,cljs.core.deref.call(null,coll));

return null;
});})(this$__$1))
)], null),((function (this$__$1){
return (function (_,xs,___$1){
return cljs.core.atom.call(null,cljs.core.first.call(null,xs));
});})(this$__$1))
);
});

schema.core.Atomic.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"atom","atom",1243487874,null));
});

schema.core.Atomic.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Atomic.cljs$lang$type = true;

schema.core.Atomic.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Atomic");
});

schema.core.Atomic.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Atomic");
});

schema.core.__GT_Atomic = (function schema$core$__GT_Atomic(schema__$1){
return (new schema.core.Atomic(schema__$1,null,null,null));
});

schema.core.map__GT_Atomic = (function schema$core$map__GT_Atomic(G__11904){
return (new schema.core.Atomic(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__11904),null,cljs.core.dissoc.call(null,G__11904,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * An atom containing a value matching 'schema'.
 */
schema.core.atom = (function schema$core$atom(schema__$1){
return schema.core.__GT_Atomic.call(null,schema__$1);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.RequiredKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.RequiredKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11911,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11913 = (((k11911 instanceof cljs.core.Keyword))?k11911.fqn:null);
switch (G__11913) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11911,else__7812__auto__);

}
});

schema.core.RequiredKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.RequiredKey{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.RequiredKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11910){
var self__ = this;
var G__11910__$1 = this;
return (new cljs.core.RecordIter((0),G__11910__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.RequiredKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.RequiredKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.RequiredKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.RequiredKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11910){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11914 = cljs.core.keyword_identical_QMARK_;
var expr__11915 = k__7817__auto__;
if(cljs.core.truth_(pred__11914.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__11915))){
return (new schema.core.RequiredKey(G__11910,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.RequiredKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11910),null));
}
});

schema.core.RequiredKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.RequiredKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11910){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.RequiredKey(self__.k,G__11910,self__.__extmap,self__.__hash));
});

schema.core.RequiredKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.RequiredKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.RequiredKey.cljs$lang$type = true;

schema.core.RequiredKey.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/RequiredKey");
});

schema.core.RequiredKey.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/RequiredKey");
});

schema.core.__GT_RequiredKey = (function schema$core$__GT_RequiredKey(k){
return (new schema.core.RequiredKey(k,null,null,null));
});

schema.core.map__GT_RequiredKey = (function schema$core$map__GT_RequiredKey(G__11912){
return (new schema.core.RequiredKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__11912),null,cljs.core.dissoc.call(null,G__11912,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * A required key in a map
 */
schema.core.required_key = (function schema$core$required_key(k){
if((k instanceof cljs.core.Keyword)){
return k;
} else {
return (new schema.core.RequiredKey(k,null,null,null));
}
});
schema.core.required_key_QMARK_ = (function schema$core$required_key_QMARK_(ks){
return ((ks instanceof cljs.core.Keyword)) || ((ks instanceof schema.core.RequiredKey));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.OptionalKey = (function (k,__meta,__extmap,__hash){
this.k = k;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.OptionalKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11919,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11921 = (((k11919 instanceof cljs.core.Keyword))?k11919.fqn:null);
switch (G__11921) {
case "k":
return self__.k;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11919,else__7812__auto__);

}
});

schema.core.OptionalKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.OptionalKey{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.OptionalKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11918){
var self__ = this;
var G__11918__$1 = this;
return (new cljs.core.RecordIter((0),G__11918__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"k","k",-2146297393)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.OptionalKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.OptionalKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.OptionalKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.OptionalKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"k","k",-2146297393),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11918){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11922 = cljs.core.keyword_identical_QMARK_;
var expr__11923 = k__7817__auto__;
if(cljs.core.truth_(pred__11922.call(null,new cljs.core.Keyword(null,"k","k",-2146297393),expr__11923))){
return (new schema.core.OptionalKey(G__11918,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.OptionalKey(self__.k,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11918),null));
}
});

schema.core.OptionalKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"k","k",-2146297393),self__.k],null))], null),self__.__extmap));
});

schema.core.OptionalKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11918){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.OptionalKey(self__.k,G__11918,self__.__extmap,self__.__hash));
});

schema.core.OptionalKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.OptionalKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"k","k",-505765866,null)], null);
});

schema.core.OptionalKey.cljs$lang$type = true;

schema.core.OptionalKey.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/OptionalKey");
});

schema.core.OptionalKey.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/OptionalKey");
});

schema.core.__GT_OptionalKey = (function schema$core$__GT_OptionalKey(k){
return (new schema.core.OptionalKey(k,null,null,null));
});

schema.core.map__GT_OptionalKey = (function schema$core$map__GT_OptionalKey(G__11920){
return (new schema.core.OptionalKey(new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(G__11920),null,cljs.core.dissoc.call(null,G__11920,new cljs.core.Keyword(null,"k","k",-2146297393)),null));
});

/**
 * An optional key in a map
 */
schema.core.optional_key = (function schema$core$optional_key(k){
return (new schema.core.OptionalKey(k,null,null,null));
});
schema.core.optional_key_QMARK_ = (function schema$core$optional_key_QMARK_(ks){
return (ks instanceof schema.core.OptionalKey);
});
schema.core.explicit_schema_key = (function schema$core$explicit_schema_key(ks){
if((ks instanceof cljs.core.Keyword)){
return ks;
} else {
if((ks instanceof schema.core.RequiredKey)){
return ks.k;
} else {
if(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,ks))){
return ks.k;
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Bad explicit key: %s",ks)));

}
}
}
});
schema.core.specific_key_QMARK_ = (function schema$core$specific_key_QMARK_(ks){
var or__7182__auto__ = schema.core.required_key_QMARK_.call(null,ks);
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
return schema.core.optional_key_QMARK_.call(null,ks);
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.MapEntry = (function (key_schema,val_schema,__meta,__extmap,__hash){
this.key_schema = key_schema;
this.val_schema = val_schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k11927,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__11929 = (((k11927 instanceof cljs.core.Keyword))?k11927.fqn:null);
switch (G__11929) {
case "key-schema":
return self__.key_schema;

break;
case "val-schema":
return self__.val_schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11927,else__7812__auto__);

}
});

schema.core.MapEntry.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.MapEntry{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.MapEntry.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11926){
var self__ = this;
var G__11926__$1 = this;
return (new cljs.core.RecordIter((0),G__11926__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.MapEntry.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.MapEntry.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__11926){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__11930 = cljs.core.keyword_identical_QMARK_;
var expr__11931 = k__7817__auto__;
if(cljs.core.truth_(pred__11930.call(null,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),expr__11931))){
return (new schema.core.MapEntry(G__11926,self__.val_schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11930.call(null,new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),expr__11931))){
return (new schema.core.MapEntry(self__.key_schema,G__11926,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__11926),null));
}
}
});

schema.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),self__.key_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619),self__.val_schema],null))], null),self__.__extmap));
});

schema.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__11926){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.MapEntry(self__.key_schema,self__.val_schema,G__11926,self__.__extmap,self__.__hash));
});

schema.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.MapEntry.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.MapEntry.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core._PLUS_no_precondition_PLUS_,cljs.core.vec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.one_element.call(null,true,self__.key_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.key.call(null,e));

return e;
});})(this$__$1))
),schema.spec.collection.one_element.call(null,true,self__.val_schema,((function (this$__$1){
return (function (item_fn,e){
item_fn.call(null,cljs.core.val.call(null,e));

return null;
});})(this$__$1))
)], null),((function (this$__$1){
return (function (p__11933,p__11934,_){
var vec__11935 = p__11933;
var k = cljs.core.nth.call(null,vec__11935,(0),null);
var vec__11938 = p__11934;
var xk = cljs.core.nth.call(null,vec__11938,(0),null);
var xv = cljs.core.nth.call(null,vec__11938,(1),null);
var temp__4655__auto__ = schema.utils.error_val.call(null,xk);
if(cljs.core.truth_(temp__4655__auto__)){
var k_err = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_err,new cljs.core.Symbol(null,"invalid-key","invalid-key",-1461682245,null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,schema.utils.error_val.call(null,xv)], null);
}
});})(this$__$1))
);
});

schema.core.MapEntry.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.key_schema);
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = schema.core.explain.call(null,self__.val_schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"map-entry","map-entry",329617471,null));
});

schema.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key-schema","key-schema",543870801,null),new cljs.core.Symbol(null,"val-schema","val-schema",-374242092,null)], null);
});

schema.core.MapEntry.cljs$lang$type = true;

schema.core.MapEntry.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/MapEntry");
});

schema.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/MapEntry");
});

schema.core.__GT_MapEntry = (function schema$core$__GT_MapEntry(key_schema,val_schema){
return (new schema.core.MapEntry(key_schema,val_schema,null,null,null));
});

schema.core.map__GT_MapEntry = (function schema$core$map__GT_MapEntry(G__11928){
return (new schema.core.MapEntry(new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726).cljs$core$IFn$_invoke$arity$1(G__11928),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619).cljs$core$IFn$_invoke$arity$1(G__11928),null,cljs.core.dissoc.call(null,G__11928,new cljs.core.Keyword(null,"key-schema","key-schema",-1096660726),new cljs.core.Keyword(null,"val-schema","val-schema",-2014773619)),null));
});

schema.core.map_entry = (function schema$core$map_entry(key_schema,val_schema){
return (new schema.core.MapEntry(key_schema,val_schema,null,null,null));
});
schema.core.find_extra_keys_schema = (function schema$core$find_extra_keys_schema(map_schema){
var key_schemata = cljs.core.remove.call(null,schema.core.specific_key_QMARK_,cljs.core.keys.call(null,map_schema));
if((cljs.core.count.call(null,key_schemata) < (2))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"More than one non-optional/required key schemata: %s",cljs.core.vec.call(null,key_schemata))));
}

return cljs.core.first.call(null,key_schemata);
});
schema.core.explain_kspec = (function schema$core$explain_kspec(kspec){
if(cljs.core.truth_(schema.core.specific_key_QMARK_.call(null,kspec))){
if((kspec instanceof cljs.core.Keyword)){
return kspec;
} else {
var x__8024__auto__ = (cljs.core.truth_(schema.core.required_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"required-key","required-key",1624616412,null):(cljs.core.truth_(schema.core.optional_key_QMARK_.call(null,kspec))?new cljs.core.Symbol(null,"optional-key","optional-key",988406145,null):null));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = schema.core.explicit_schema_key.call(null,kspec);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
}
} else {
return schema.core.explain.call(null,kspec);
}
});
schema.core.map_elements = (function schema$core$map_elements(this$){
var extra_keys_schema = schema.core.find_extra_keys_schema.call(null,this$);
var duplicate_keys_11975 = cljs.core.mapv.call(null,schema.core.explain_kspec,cljs.core.apply.call(null,cljs.core.concat,cljs.core.filter.call(null,((function (extra_keys_schema){
return (function (p1__11942_SHARP_){
return (cljs.core.count.call(null,p1__11942_SHARP_) > (1));
});})(extra_keys_schema))
,cljs.core.vals.call(null,cljs.core.group_by.call(null,schema.core.explicit_schema_key,cljs.core.keys.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema)))))));
if(cljs.core.empty_QMARK_.call(null,duplicate_keys_11975)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Schema has multiple variants of the same explicit key: %s",duplicate_keys_11975)));
}

return cljs.core.concat.call(null,(function (){var iter__7970__auto__ = ((function (extra_keys_schema){
return (function schema$core$map_elements_$_iter__11959(s__11960){
return (new cljs.core.LazySeq(null,((function (extra_keys_schema){
return (function (){
var s__11960__$1 = s__11960;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11960__$1);
if(temp__4657__auto__){
var s__11960__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11960__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11960__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11962 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11961 = (0);
while(true){
if((i__11961 < size__7969__auto__)){
var vec__11969 = cljs.core._nth.call(null,c__7968__auto__,i__11961);
var k = cljs.core.nth.call(null,vec__11969,(0),null);
var v = cljs.core.nth.call(null,vec__11969,(1),null);
cljs.core.chunk_append.call(null,b__11962,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (i__11961,rk,required_QMARK_,vec__11969,k,v,c__7968__auto__,size__7969__auto__,b__11962,s__11960__$2,temp__4657__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(i__11961,rk,required_QMARK_,vec__11969,k,v,c__7968__auto__,size__7969__auto__,b__11962,s__11960__$2,temp__4657__auto__,extra_keys_schema))
);
})());

var G__11976 = (i__11961 + (1));
i__11961 = G__11976;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11962),schema$core$map_elements_$_iter__11959.call(null,cljs.core.chunk_rest.call(null,s__11960__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11962),null);
}
} else {
var vec__11972 = cljs.core.first.call(null,s__11960__$2);
var k = cljs.core.nth.call(null,vec__11972,(0),null);
var v = cljs.core.nth.call(null,vec__11972,(1),null);
return cljs.core.cons.call(null,(function (){var rk = schema.core.explicit_schema_key.call(null,k);
var required_QMARK_ = schema.core.required_key_QMARK_.call(null,k);
return schema.spec.collection.one_element.call(null,required_QMARK_,schema.core.map_entry.call(null,schema.core.eq.call(null,rk),v),((function (rk,required_QMARK_,vec__11972,k,v,s__11960__$2,temp__4657__auto__,extra_keys_schema){
return (function (item_fn,m){
var e = cljs.core.find.call(null,m,rk);
if(cljs.core.truth_(e)){
item_fn.call(null,e);
} else {
if(cljs.core.truth_(required_QMARK_)){
item_fn.call(null,schema.utils.error.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rk,new cljs.core.Symbol(null,"missing-required-key","missing-required-key",709961446,null)], null)));
} else {
}
}

if(cljs.core.truth_(e)){
return cljs.core.dissoc.call(null,m,rk);
} else {
return m;
}
});})(rk,required_QMARK_,vec__11972,k,v,s__11960__$2,temp__4657__auto__,extra_keys_schema))
);
})(),schema$core$map_elements_$_iter__11959.call(null,cljs.core.rest.call(null,s__11960__$2)));
}
} else {
return null;
}
break;
}
});})(extra_keys_schema))
,null,null));
});})(extra_keys_schema))
;
return iter__7970__auto__.call(null,cljs.core.dissoc.call(null,this$,extra_keys_schema));
})(),(cljs.core.truth_(extra_keys_schema)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.apply.call(null,schema.core.map_entry,cljs.core.find.call(null,this$,extra_keys_schema)))], null):null));
});
schema.core.map_error = (function schema$core$map_error(){
return (function (_,elts,extra){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.concat.call(null,cljs.core.keep.call(null,schema.utils.error_val,elts),(function (){var iter__7970__auto__ = (function schema$core$map_error_$_iter__11993(s__11994){
return (new cljs.core.LazySeq(null,(function (){
var s__11994__$1 = s__11994;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__11994__$1);
if(temp__4657__auto__){
var s__11994__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__11994__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__11994__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__11996 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__11995 = (0);
while(true){
if((i__11995 < size__7969__auto__)){
var vec__12003 = cljs.core._nth.call(null,c__7968__auto__,i__11995);
var k = cljs.core.nth.call(null,vec__12003,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__12003,(1),null);
cljs.core.chunk_append.call(null,b__11996,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null));

var G__12009 = (i__11995 + (1));
i__11995 = G__12009;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11996),schema$core$map_error_$_iter__11993.call(null,cljs.core.chunk_rest.call(null,s__11994__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__11996),null);
}
} else {
var vec__12006 = cljs.core.first.call(null,s__11994__$2);
var k = cljs.core.nth.call(null,vec__12006,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__12006,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,new cljs.core.Symbol(null,"disallowed-key","disallowed-key",-1877785633,null)], null),schema$core$map_error_$_iter__11993.call(null,cljs.core.rest.call(null,s__11994__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7970__auto__.call(null,extra);
})()));
});
});
schema.core.map_spec = (function schema$core$map_spec(this$){
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$,cljs.core.map_QMARK_,(function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"map?","map?",-1780568534,null));
})),(function (p1__12010_SHARP_){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,p1__12010_SHARP_);
}),schema.core.map_elements.call(null,this$),schema.core.map_error.call(null));
});
schema.core.map_explain = (function schema$core$map_explain(this$){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7970__auto__ = (function schema$core$map_explain_$_iter__12027(s__12028){
return (new cljs.core.LazySeq(null,(function (){
var s__12028__$1 = s__12028;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__12028__$1);
if(temp__4657__auto__){
var s__12028__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12028__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__12028__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__12030 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__12029 = (0);
while(true){
if((i__12029 < size__7969__auto__)){
var vec__12037 = cljs.core._nth.call(null,c__7968__auto__,i__12029);
var k = cljs.core.nth.call(null,vec__12037,(0),null);
var v = cljs.core.nth.call(null,vec__12037,(1),null);
cljs.core.chunk_append.call(null,b__12030,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null));

var G__12043 = (i__12029 + (1));
i__12029 = G__12043;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12030),schema$core$map_explain_$_iter__12027.call(null,cljs.core.chunk_rest.call(null,s__12028__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12030),null);
}
} else {
var vec__12040 = cljs.core.first.call(null,s__12028__$2);
var k = cljs.core.nth.call(null,vec__12040,(0),null);
var v = cljs.core.nth.call(null,vec__12040,(1),null);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain_kspec.call(null,k),schema.core.explain.call(null,v)], null),schema$core$map_explain_$_iter__12027.call(null,cljs.core.rest.call(null,s__12028__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7970__auto__.call(null,this$);
})());
});
cljs.core.PersistentArrayMap.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentArrayMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_spec.call(null,this$__$1);
});

cljs.core.PersistentHashMap.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return schema.core.map_explain.call(null,this$__$1);
});
cljs.core.PersistentHashSet.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,this$__$1),(1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Set schema must have exactly one element")));
}

return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.set_QMARK_,((function (this$__$1){
return (function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"set?","set?",1636014792,null));
});})(this$__$1))
),cljs.core.set,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,cljs.core.first.call(null,this$__$1))], null),((function (this$__$1){
return (function (_,xs,___$1){
return cljs.core.set.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

cljs.core.PersistentHashSet.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,cljs.core.first.call(null,this$__$1))], null));
});
schema.core.queue_QMARK_ = (function schema$core$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
schema.core.as_queue = (function schema$core$as_queue(col){
return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.PersistentQueue.EMPTY,col);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Queue = (function (schema,__meta,__extmap,__hash){
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Queue.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k12045,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__12047 = (((k12045 instanceof cljs.core.Keyword))?k12045.fqn:null);
switch (G__12047) {
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12045,else__7812__auto__);

}
});

schema.core.Queue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Queue{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Queue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12044){
var self__ = this;
var G__12044__$1 = this;
return (new cljs.core.RecordIter((0),G__12044__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Queue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Queue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Queue(self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (1 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Queue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Queue.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Queue.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__12044){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__12048 = cljs.core.keyword_identical_QMARK_;
var expr__12049 = k__7817__auto__;
if(cljs.core.truth_(pred__12048.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__12049))){
return (new schema.core.Queue(G__12044,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Queue(self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__12044),null));
}
});

schema.core.Queue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Queue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__12044){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Queue(self__.schema,G__12044,self__.__extmap,self__.__hash));
});

schema.core.Queue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Queue.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Queue.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,schema.core.queue_QMARK_,((function (this$__$1){
return (function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"queue?","queue?",-880510795,null));
});})(this$__$1))
),schema.core.as_queue,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,self__.schema)], null),((function (this$__$1){
return (function (_,xs,___$1){
return schema.core.as_queue.call(null,cljs.core.keep.call(null,schema.utils.error_val,xs));
});})(this$__$1))
);
});

schema.core.Queue.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"queue","queue",-1198599890,null));
});

schema.core.Queue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Queue.cljs$lang$type = true;

schema.core.Queue.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Queue");
});

schema.core.Queue.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Queue");
});

schema.core.__GT_Queue = (function schema$core$__GT_Queue(schema__$1){
return (new schema.core.Queue(schema__$1,null,null,null));
});

schema.core.map__GT_Queue = (function schema$core$map__GT_Queue(G__12046){
return (new schema.core.Queue(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__12046),null,cljs.core.dissoc.call(null,G__12046,new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

/**
 * Defines a schema satisfied by instances of clojure.lang.PersistentQueue
 *   (clj.core/PersistentQueue in ClojureScript) whose values satisfy x.
 */
schema.core.queue = (function schema$core$queue(x){
return (new schema.core.Queue(x,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.One = (function (schema,optional_QMARK_,name,__meta,__extmap,__hash){
this.schema = schema;
this.optional_QMARK_ = optional_QMARK_;
this.name = name;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.One.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k12053,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__12055 = (((k12053 instanceof cljs.core.Keyword))?k12053.fqn:null);
switch (G__12055) {
case "schema":
return self__.schema;

break;
case "optional?":
return self__.optional_QMARK_;

break;
case "name":
return self__.name;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12053,else__7812__auto__);

}
});

schema.core.One.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.One{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.One.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12052){
var self__ = this;
var G__12052__$1 = this;
return (new cljs.core.RecordIter((0),G__12052__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.One.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.One.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.One.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.One.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.One.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.One.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__12052){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__12056 = cljs.core.keyword_identical_QMARK_;
var expr__12057 = k__7817__auto__;
if(cljs.core.truth_(pred__12056.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__12057))){
return (new schema.core.One(G__12052,self__.optional_QMARK_,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12056.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129),expr__12057))){
return (new schema.core.One(self__.schema,G__12052,self__.name,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12056.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__12057))){
return (new schema.core.One(self__.schema,self__.optional_QMARK_,G__12052,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__12052),null));
}
}
}
});

schema.core.One.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"optional?","optional?",1184638129),self__.optional_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null))], null),self__.__extmap));
});

schema.core.One.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__12052){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.One(self__.schema,self__.optional_QMARK_,self__.name,G__12052,self__.__extmap,self__.__hash));
});

schema.core.One.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.One.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"optional?","optional?",-1469797640,null),new cljs.core.Symbol(null,"name","name",-810760592,null)], null);
});

schema.core.One.cljs$lang$type = true;

schema.core.One.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/One");
});

schema.core.One.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/One");
});

schema.core.__GT_One = (function schema$core$__GT_One(schema__$1,optional_QMARK_,name){
return (new schema.core.One(schema__$1,optional_QMARK_,name,null,null,null));
});

schema.core.map__GT_One = (function schema$core$map__GT_One(G__12054){
return (new schema.core.One(new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__12054),new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(G__12054),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__12054),null,cljs.core.dissoc.call(null,G__12054,new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"optional?","optional?",1184638129),new cljs.core.Keyword(null,"name","name",1843675177)),null));
});

/**
 * A single required element of a sequence (not repeated, the implicit default)
 */
schema.core.one = (function schema$core$one(schema__$1,name){
return (new schema.core.One(schema__$1,false,name,null,null,null));
});
/**
 * A single optional element of a sequence (not repeated, the implicit default)
 */
schema.core.optional = (function schema$core$optional(schema__$1,name){
return (new schema.core.One(schema__$1,true,name,null,null,null));
});
schema.core.parse_sequence_schema = (function schema$core$parse_sequence_schema(s){

var vec__12069 = cljs.core.split_with.call(null,(function (p1__12060_SHARP_){
return ((p1__12060_SHARP_ instanceof schema.core.One)) && (cljs.core.not.call(null,new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__12060_SHARP_)));
}),s);
var required = cljs.core.nth.call(null,vec__12069,(0),null);
var more = cljs.core.nth.call(null,vec__12069,(1),null);
var vec__12072 = cljs.core.split_with.call(null,((function (vec__12069,required,more){
return (function (p1__12061_SHARP_){
var and__7170__auto__ = (p1__12061_SHARP_ instanceof schema.core.One);
if(and__7170__auto__){
return new cljs.core.Keyword(null,"optional?","optional?",1184638129).cljs$core$IFn$_invoke$arity$1(p1__12061_SHARP_);
} else {
return and__7170__auto__;
}
});})(vec__12069,required,more))
,more);
var optional = cljs.core.nth.call(null,vec__12072,(0),null);
var more__$1 = cljs.core.nth.call(null,vec__12072,(1),null);
if(((cljs.core.count.call(null,more__$1) <= (1))) && (cljs.core.every_QMARK_.call(null,((function (vec__12069,required,more,vec__12072,optional,more__$1){
return (function (p1__12062_SHARP_){
return !((p1__12062_SHARP_ instanceof schema.core.One));
});})(vec__12069,required,more,vec__12072,optional,more__$1))
,more__$1))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"%s is not a valid sequence schema; %s%s%s",s,"a valid sequence schema consists of zero or more `one` elements, ","followed by zero or more `optional` elements, followed by an optional ","schema that will match the remaining elements.")));
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,required,optional),cljs.core.first.call(null,more__$1)], null);
});
cljs.core.PersistentVector.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (x){
return ((x == null)) || (cljs.core.sequential_QMARK_.call(null,x));
});})(this$__$1))
,((function (this$__$1){
return (function (p1__12075_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__12075_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"sequential?","sequential?",1102351463,null));
});})(this$__$1))
),cljs.core.vec,(function (){var vec__12076 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__12076,(0),null);
var multi = cljs.core.nth.call(null,vec__12076,(1),null);
return cljs.core.reduce.call(null,((function (vec__12076,singles,multi,this$__$1){
return (function (more,s){
if(cljs.core.not.call(null,s.optional_QMARK_)){
return cljs.core.cons.call(null,schema.spec.collection.one_element.call(null,true,schema.core.named.call(null,s.schema,s.name),((function (vec__12076,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__4655__auto__ = cljs.core.seq.call(null,x);
if(temp__4655__auto__){
var x__$1 = temp__4655__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
item_fn.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s.schema,new cljs.core.Keyword("schema.core","missing","schema.core/missing",1420181325),(new cljs.core.Delay(((function (temp__4655__auto__,vec__12076,singles,multi,this$__$1){
return (function (){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = s.name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"present?","present?",-1810613791,null));
});})(temp__4655__auto__,vec__12076,singles,multi,this$__$1))
,null)),null)));

return null;
}
});})(vec__12076,singles,multi,this$__$1))
),more);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.optional_tail.call(null,schema.core.named.call(null,s.schema,s.name),((function (vec__12076,singles,multi,this$__$1){
return (function (item_fn,x){
var temp__4657__auto__ = cljs.core.seq.call(null,x);
if(temp__4657__auto__){
var x__$1 = temp__4657__auto__;
item_fn.call(null,cljs.core.first.call(null,x__$1));

return cljs.core.rest.call(null,x__$1);
} else {
return null;
}
});})(vec__12076,singles,multi,this$__$1))
,more)], null);
}
});})(vec__12076,singles,multi,this$__$1))
,(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.spec.collection.all_elements.call(null,multi)], null):null),cljs.core.reverse.call(null,singles));
})(),((function (this$__$1){
return (function (_,elts,extra){
var head = cljs.core.mapv.call(null,schema.utils.error_val,elts);
if(cljs.core.seq.call(null,extra)){
return cljs.core.conj.call(null,head,schema.utils.error_val.call(null,schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,null,extra,(new cljs.core.Delay(((function (head,this$__$1){
return (function (){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = cljs.core.count.call(null,extra);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"has-extra-elts?","has-extra-elts?",-1376562869,null));
});})(head,this$__$1))
,null)),null))));
} else {
return head;
}
});})(this$__$1))
);
});

cljs.core.PersistentVector.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var this$__$1 = this;
var vec__12079 = schema.core.parse_sequence_schema.call(null,this$__$1);
var singles = cljs.core.nth.call(null,vec__12079,(0),null);
var multi = cljs.core.nth.call(null,vec__12079,(1),null);
return cljs.core.vec.call(null,cljs.core.concat.call(null,(function (){var iter__7970__auto__ = ((function (vec__12079,singles,multi,this$__$1){
return (function schema$core$iter__12082(s__12083){
return (new cljs.core.LazySeq(null,((function (vec__12079,singles,multi,this$__$1){
return (function (){
var s__12083__$1 = s__12083;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__12083__$1);
if(temp__4657__auto__){
var s__12083__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__12083__$2)){
var c__7968__auto__ = cljs.core.chunk_first.call(null,s__12083__$2);
var size__7969__auto__ = cljs.core.count.call(null,c__7968__auto__);
var b__12085 = cljs.core.chunk_buffer.call(null,size__7969__auto__);
if((function (){var i__12084 = (0);
while(true){
if((i__12084 < size__7969__auto__)){
var s = cljs.core._nth.call(null,c__7968__auto__,i__12084);
cljs.core.chunk_append.call(null,b__12085,(function (){var x__8024__auto__ = (cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$2 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$2);
})(),x__8024__auto____$1);
})(),x__8024__auto__);
})());

var G__12086 = (i__12084 + (1));
i__12084 = G__12086;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12085),schema$core$iter__12082.call(null,cljs.core.chunk_rest.call(null,s__12083__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__12085),null);
}
} else {
var s = cljs.core.first.call(null,s__12083__$2);
return cljs.core.cons.call(null,(function (){var x__8024__auto__ = (cljs.core.truth_(s.optional_QMARK_)?new cljs.core.Symbol(null,"optional","optional",-600484260,null):new cljs.core.Symbol(null,"one","one",-1719427865,null));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = schema.core.explain.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(s));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$2 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$2);
})(),x__8024__auto____$1);
})(),x__8024__auto__);
})(),schema$core$iter__12082.call(null,cljs.core.rest.call(null,s__12083__$2)));
}
} else {
return null;
}
break;
}
});})(vec__12079,singles,multi,this$__$1))
,null,null));
});})(vec__12079,singles,multi,this$__$1))
;
return iter__7970__auto__.call(null,singles);
})(),(cljs.core.truth_(multi)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.explain.call(null,multi)], null):null)));
});
/**
 * A schema for a pair of schemas and their names
 */
schema.core.pair = (function schema$core$pair(first_schema,first_name,second_schema,second_name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,first_schema,first_name),schema.core.one.call(null,second_schema,second_name)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.Record = (function (klass,schema,__meta,__extmap,__hash){
this.klass = klass;
this.schema = schema;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.Record.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k12091,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__12093 = (((k12091 instanceof cljs.core.Keyword))?k12091.fqn:null);
switch (G__12093) {
case "klass":
return self__.klass;

break;
case "schema":
return self__.schema;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12091,else__7812__auto__);

}
});

schema.core.Record.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.Record{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Record.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12090){
var self__ = this;
var G__12090__$1 = this;
return (new cljs.core.RecordIter((0),G__12090__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.Record.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.Record.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.Record.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.Record.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"klass","klass",-1386752349),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.Record.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__12090){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__12094 = cljs.core.keyword_identical_QMARK_;
var expr__12095 = k__7817__auto__;
if(cljs.core.truth_(pred__12094.call(null,new cljs.core.Keyword(null,"klass","klass",-1386752349),expr__12095))){
return (new schema.core.Record(G__12090,self__.schema,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12094.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__12095))){
return (new schema.core.Record(self__.klass,G__12090,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.Record(self__.klass,self__.schema,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__12090),null));
}
}
});

schema.core.Record.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"klass","klass",-1386752349),self__.klass],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null))], null),self__.__extmap));
});

schema.core.Record.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__12090){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.Record(self__.klass,self__.schema,G__12090,self__.__extmap,self__.__hash));
});

schema.core.Record.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.Record.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.Record.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.collection.collection_spec.call(null,(function (){var p = schema.spec.core.precondition.call(null,this$__$1,((function (this$__$1){
return (function (p1__12087_SHARP_){
return (p1__12087_SHARP_ instanceof self__.klass);
});})(this$__$1))
,((function (this$__$1){
return (function (p1__12088_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = self__.klass;
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = p1__12088_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"instance?","instance?",1075939923,null));
});})(this$__$1))
);
var temp__4655__auto__ = new cljs.core.Keyword(null,"extra-validator-fn","extra-validator-fn",1562905865).cljs$core$IFn$_invoke$arity$1(this$__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var evf = temp__4655__auto__;
return cljs.core.some_fn.call(null,p,schema.spec.core.precondition.call(null,this$__$1,evf,((function (evf,temp__4655__auto__,p,this$__$1){
return (function (p1__12089_SHARP_){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__12089_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"passes-extra-validation?","passes-extra-validation?",-1964809231,null));
});})(evf,temp__4655__auto__,p,this$__$1))
));
} else {
return p;
}
})(),new cljs.core.Keyword(null,"constructor","constructor",-1953928811).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,this$__$1)),schema.core.map_elements.call(null,self__.schema),schema.core.map_error.call(null));
});

schema.core.Record.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = cljs.core.symbol.call(null,cljs.core.pr_str.call(null,self__.klass));
return cljs.core._conj.call(null,(function (){var x__8024__auto____$1 = schema.core.explain.call(null,self__.schema);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto____$1);
})(),x__8024__auto__);
})(),new cljs.core.Symbol(null,"record","record",861424668,null));
});

schema.core.Record.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"klass","klass",253779178,null),new cljs.core.Symbol(null,"schema","schema",58529736,null)], null);
});

schema.core.Record.cljs$lang$type = true;

schema.core.Record.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/Record");
});

schema.core.Record.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/Record");
});

schema.core.__GT_Record = (function schema$core$__GT_Record(klass,schema__$1){
return (new schema.core.Record(klass,schema__$1,null,null,null));
});

schema.core.map__GT_Record = (function schema$core$map__GT_Record(G__12092){
return (new schema.core.Record(new cljs.core.Keyword(null,"klass","klass",-1386752349).cljs$core$IFn$_invoke$arity$1(G__12092),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__12092),null,cljs.core.dissoc.call(null,G__12092,new cljs.core.Keyword(null,"klass","klass",-1386752349),new cljs.core.Keyword(null,"schema","schema",-1582001791)),null));
});

schema.core.record_STAR_ = (function schema$core$record_STAR_(klass,schema__$1,map_constructor){
if(cljs.core.map_QMARK_.call(null,schema__$1)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Expected map, got %s",schema.utils.type_of.call(null,schema__$1))));
}

return cljs.core.with_meta.call(null,(new schema.core.Record(klass,schema__$1,null,null,null)),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"constructor","constructor",-1953928811),map_constructor], null));
});
schema.core.explain_input_schema = (function schema$core$explain_input_schema(input_schema){
var vec__12103 = cljs.core.split_with.call(null,(function (p1__12098_SHARP_){
return (p1__12098_SHARP_ instanceof schema.core.One);
}),input_schema);
var required = cljs.core.nth.call(null,vec__12103,(0),null);
var more = cljs.core.nth.call(null,vec__12103,(1),null);
return cljs.core.concat.call(null,cljs.core.map.call(null,((function (vec__12103,required,more){
return (function (p1__12099_SHARP_){
return schema.core.explain.call(null,p1__12099_SHARP_.schema);
});})(vec__12103,required,more))
,required),((cljs.core.seq.call(null,more))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&","&",-2144855648,null),cljs.core.mapv.call(null,schema.core.explain,more)], null):null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {schema.core.Schema}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
schema.core.FnSchema = (function (output_schema,input_schemas,__meta,__extmap,__hash){
this.output_schema = output_schema;
this.input_schemas = input_schemas;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7809__auto__,k__7810__auto__){
var self__ = this;
var this__7809__auto____$1 = this;
return this__7809__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7810__auto__,null);
});

schema.core.FnSchema.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7811__auto__,k12107,else__7812__auto__){
var self__ = this;
var this__7811__auto____$1 = this;
var G__12109 = (((k12107 instanceof cljs.core.Keyword))?k12107.fqn:null);
switch (G__12109) {
case "output-schema":
return self__.output_schema;

break;
case "input-schemas":
return self__.input_schemas;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k12107,else__7812__auto__);

}
});

schema.core.FnSchema.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7823__auto__,writer__7824__auto__,opts__7825__auto__){
var self__ = this;
var this__7823__auto____$1 = this;
var pr_pair__7826__auto__ = ((function (this__7823__auto____$1){
return (function (keyval__7827__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,cljs.core.pr_writer,""," ","",opts__7825__auto__,keyval__7827__auto__);
});})(this__7823__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__7824__auto__,pr_pair__7826__auto__,"#schema.core.FnSchema{",", ","}",opts__7825__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.FnSchema.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12106){
var self__ = this;
var G__12106__$1 = this;
return (new cljs.core.RecordIter((0),G__12106__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

schema.core.FnSchema.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7807__auto__){
var self__ = this;
var this__7807__auto____$1 = this;
return self__.__meta;
});

schema.core.FnSchema.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7803__auto__){
var self__ = this;
var this__7803__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7813__auto__){
var self__ = this;
var this__7813__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7804__auto__){
var self__ = this;
var this__7804__auto____$1 = this;
var h__7622__auto__ = self__.__hash;
if(!((h__7622__auto__ == null))){
return h__7622__auto__;
} else {
var h__7622__auto____$1 = cljs.core.hash_imap.call(null,this__7804__auto____$1);
self__.__hash = h__7622__auto____$1;

return h__7622__auto____$1;
}
});

schema.core.FnSchema.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7805__auto__,other__7806__auto__){
var self__ = this;
var this__7805__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7170__auto__ = other__7806__auto__;
if(cljs.core.truth_(and__7170__auto__)){
return ((this__7805__auto____$1.constructor === other__7806__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__7805__auto____$1,other__7806__auto__));
} else {
return and__7170__auto__;
}
})())){
return true;
} else {
return false;
}
});

schema.core.FnSchema.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7818__auto__,k__7819__auto__){
var self__ = this;
var this__7818__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"output-schema","output-schema",272504137),null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),null], null), null),k__7819__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__7818__auto____$1),self__.__meta),k__7819__auto__);
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__7819__auto__)),null));
}
});

schema.core.FnSchema.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7816__auto__,k__7817__auto__,G__12106){
var self__ = this;
var this__7816__auto____$1 = this;
var pred__12110 = cljs.core.keyword_identical_QMARK_;
var expr__12111 = k__7817__auto__;
if(cljs.core.truth_(pred__12110.call(null,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),expr__12111))){
return (new schema.core.FnSchema(G__12106,self__.input_schemas,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__12110.call(null,new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),expr__12111))){
return (new schema.core.FnSchema(self__.output_schema,G__12106,self__.__meta,self__.__extmap,null));
} else {
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__7817__auto__,G__12106),null));
}
}
});

schema.core.FnSchema.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7821__auto__){
var self__ = this;
var this__7821__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"output-schema","output-schema",272504137),self__.output_schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805),self__.input_schemas],null))], null),self__.__extmap));
});

schema.core.FnSchema.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7808__auto__,G__12106){
var self__ = this;
var this__7808__auto____$1 = this;
return (new schema.core.FnSchema(self__.output_schema,self__.input_schemas,G__12106,self__.__extmap,self__.__hash));
});

schema.core.FnSchema.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7814__auto__,entry__7815__auto__){
var self__ = this;
var this__7814__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__7815__auto__)){
return this__7814__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__7815__auto__,(0)),cljs.core._nth.call(null,entry__7815__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__7814__auto____$1,entry__7815__auto__);
}
});

schema.core.FnSchema.prototype.schema$core$Schema$ = cljs.core.PROTOCOL_SENTINEL;

schema.core.FnSchema.prototype.schema$core$Schema$spec$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return schema.spec.leaf.leaf_spec.call(null,schema.spec.core.precondition.call(null,this$__$1,cljs.core.ifn_QMARK_,((function (this$__$1){
return (function (p1__10313__10314__auto__){
return cljs.core._conj.call(null,(function (){var x__8024__auto__ = p1__10313__10314__auto__;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8024__auto__);
})(),new cljs.core.Symbol(null,"ifn?","ifn?",-2106461064,null));
});})(this$__$1))
));
});

schema.core.FnSchema.prototype.schema$core$Schema$explain$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.input_schemas) > (1))){
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>*","=>*",1909690043,null),schema.core.explain.call(null,self__.output_schema),cljs.core.map.call(null,schema.core.explain_input_schema,self__.input_schemas));
} else {
return cljs.core.list_STAR_.call(null,new cljs.core.Symbol(null,"=>","=>",-813269641,null),schema.core.explain.call(null,self__.output_schema),schema.core.explain_input_schema.call(null,cljs.core.first.call(null,self__.input_schemas)));
}
});

schema.core.FnSchema.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"output-schema","output-schema",1913035664,null),new cljs.core.Symbol(null,"input-schemas","input-schemas",658376722,null)], null);
});

schema.core.FnSchema.cljs$lang$type = true;

schema.core.FnSchema.cljs$lang$ctorPrSeq = (function (this__7843__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"schema.core/FnSchema");
});

schema.core.FnSchema.cljs$lang$ctorPrWriter = (function (this__7843__auto__,writer__7844__auto__){
return cljs.core._write.call(null,writer__7844__auto__,"schema.core/FnSchema");
});

schema.core.__GT_FnSchema = (function schema$core$__GT_FnSchema(output_schema,input_schemas){
return (new schema.core.FnSchema(output_schema,input_schemas,null,null,null));
});

schema.core.map__GT_FnSchema = (function schema$core$map__GT_FnSchema(G__12108){
return (new schema.core.FnSchema(new cljs.core.Keyword(null,"output-schema","output-schema",272504137).cljs$core$IFn$_invoke$arity$1(G__12108),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805).cljs$core$IFn$_invoke$arity$1(G__12108),null,cljs.core.dissoc.call(null,G__12108,new cljs.core.Keyword(null,"output-schema","output-schema",272504137),new cljs.core.Keyword(null,"input-schemas","input-schemas",-982154805)),null));
});

schema.core.arity = (function schema$core$arity(input_schema){
if(cljs.core.seq.call(null,input_schema)){
if((cljs.core.last.call(null,input_schema) instanceof schema.core.One)){
return cljs.core.count.call(null,input_schema);
} else {
return Number.MAX_VALUE;
}
} else {
return (0);
}
});
/**
 * A function outputting a value in output schema, whose argument vector must match one of
 * input-schemas, each of which should be a sequence schema.
 * Currently function schemas are purely descriptive; they validate against any function,
 * regardless of actual input and output types.
 */
schema.core.make_fn_schema = (function schema$core$make_fn_schema(output_schema,input_schemas){
if(cljs.core.seq.call(null,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Function must have at least one input schema")));
}

if(cljs.core.every_QMARK_.call(null,cljs.core.vector_QMARK_,input_schemas)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Each arity must be a vector.")));
}

if(cljs.core.truth_(cljs.core.apply.call(null,cljs.core.distinct_QMARK_,cljs.core.map.call(null,schema.core.arity,input_schemas)))){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Arities must be distinct")));
}

return (new schema.core.FnSchema(output_schema,cljs.core.sort_by.call(null,schema.core.arity,input_schemas),null,null,null));
});
/**
 * Records name in schema's metadata.
 */
schema.core.schema_with_name = (function schema$core$schema_with_name(schema__$1,name){
return cljs.core.vary_meta.call(null,schema__$1,cljs.core.assoc,new cljs.core.Keyword(null,"name","name",1843675177),name);
});
/**
 * Returns the name of a schema attached via schema-with-name (or defschema).
 */
schema.core.schema_name = (function schema$core$schema_name(schema__$1){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Returns the namespace of a schema attached via defschema.
 */
schema.core.schema_ns = (function schema$core$schema_ns(schema__$1){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,schema__$1));
});
/**
 * Get the current global schema validation setting.
 */
schema.core.fn_validation_QMARK_ = (function schema$core$fn_validation_QMARK_(){
return cljs.core.deref.call(null,schema.utils.use_fn_validation);
});
/**
 * Globally turn on (or off) schema validation for all s/fn and s/defn instances.
 */
schema.core.set_fn_validation_BANG_ = (function schema$core$set_fn_validation_BANG_(on_QMARK_){
return cljs.core.reset_BANG_.call(null,schema.utils.use_fn_validation,on_QMARK_);
});
/**
 * Attach the schema to fn f at runtime, extractable by fn-schema.
 */
schema.core.schematize_fn = (function schema$core$schematize_fn(f,schema__$1){
return cljs.core.vary_meta.call(null,f,cljs.core.assoc,new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1);
});
/**
 * Produce the schema for a function defined with s/fn or s/defn.
 */
schema.core.fn_schema = (function schema$core$fn_schema(f){
if(cljs.core.fn_QMARK_.call(null,f)){
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Non-function %s",schema.utils.type_of.call(null,f))));
}

var or__7182__auto__ = schema.utils.class_schema.call(null,schema.utils.fn_schema_bearer.call(null,f));
if(cljs.core.truth_(or__7182__auto__)){
return or__7182__auto__;
} else {
var m__10055__auto__ = cljs.core.meta.call(null,f);
var k__10056__auto__ = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var temp__4655__auto__ = cljs.core.find.call(null,m__10055__auto__,k__10056__auto__);
if(cljs.core.truth_(temp__4655__auto__)){
var pair__10057__auto__ = temp__4655__auto__;
return cljs.core.val.call(null,pair__10057__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k__10056__auto__,m__10055__auto__)));
}
}
});
/**
 * Sets the maximum length of value to be output before it is contracted to a prettier name.
 */
schema.core.set_max_value_length_BANG_ = (function schema$core$set_max_value_length_BANG_(max_length){
return cljs.core.reset_BANG_.call(null,schema.utils.max_value_length,max_length);
});

//# sourceMappingURL=core.js.map