(ns meta.dom.mdc
  (:require [hoplon.core :as h]
            [javelin.core :as j]
            [hoplon.bidi]
            [material-hl.core :as mwc])
  (:require-macros [hoplon.bidi :refer [route-tpl]]))

(h/defelem head [attr kids]
  (let [title (:title attr)]
    (h/head attr
      (html-meta :http-equiv "content-type" :content "text/html; charset=utf-8")
      (html-meta :name "viewport" :content "width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=0")
      (title title)
      (link :rel "shortcut icon" :href "favicon.ico")
      (link :rel "stylesheet" :href "css/material-components-web.css")
      kids)))

(h/defelem body [attr kids]
  (let [toolbar (:toolbar attr :temporary)]
    (body
      (assoc attr :style {:min-height "100%"})
      (case-tpl toolbar
        ;:temporary ()
        ))))

(h/defelem app [attr kids]
  (let [toolbar (:toolbar attr :temporary)]
    (h/html
      (head)
      (body kids))))


;(route-tpl routes
;  :chat    (chat/chat)
;  :landing (view/landing)
;  :login   (view/login)
;  :signup  (view/signup)
;  :missing "404!")
