'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = init;

var _index = require('./hooks/index');

var _index2 = _interopRequireDefault(_index);

var _passport = require('./passport');

var _passport2 = _interopRequireDefault(_passport);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var defaults = {
  header: 'Authorization',
  cookie: 'feathers-jwt',
  storageKey: 'feathers-jwt',
  jwtStrategy: 'jwt',
  path: '/authentication',
  entity: 'user',
  service: 'users',
  timeout: 5000
};

function init() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var options = Object.assign({}, defaults, config);

  return function () {
    var app = this;

    app.passport = new _passport2.default(app, options);
    app.authenticate = app.passport.authenticate.bind(app.passport);
    app.logout = app.passport.logout.bind(app.passport);

    // Set up hook that adds token and user to params so that
    // it they can be accessed by client side hooks and services
    app.mixins.push(function (service) {
      // if (typeof service.hooks !== 'function') {
      if (typeof service.before !== 'function' || typeof service.after !== 'function') {
        throw new Error('It looks like feathers-hooks isn\'t configured. It is required before running feathers-authentication.');
      }

      service.before(_index2.default.populateAccessToken(options));
    });

    // Set up hook that adds authorization header for REST provider
    if (app.rest) {
      app.mixins.push(function (service) {
        service.before(_index2.default.populateHeader(options));
      });
    }
  };
}

init.defaults = defaults;
module.exports = exports['default'];