'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = hashPassword;

var _hash = require('../utils/hash');

var _hash2 = _interopRequireDefault(_hash);

var _lodash = require('lodash.merge');

var _lodash2 = _interopRequireDefault(_lodash);

var _debug = require('debug');

var _debug2 = _interopRequireDefault(_debug);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var debug = (0, _debug2.default)('feathers-authentication-local:hooks:hash-password');

function hashPassword() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  return function (hook) {
    if (hook.type !== 'before') {
      return Promise.reject(new Error('The \'hashPassword\' hook should only be used as a \'before\' hook.'));
    }

    var app = hook.app;
    var authOptions = app.get('authentication') || {};

    options = (0, _lodash2.default)({ passwordField: 'password' }, authOptions.local, options);

    debug('Running hashPassword hook with options:', options);

    var field = options.passwordField;
    var hashPw = options.hash || _hash2.default;

    if (typeof field !== 'string') {
      return Promise.reject(new Error('You must provide a \'passwordField\' in your authentication configuration or pass one explicitly'));
    }

    if (typeof hashPw !== 'function') {
      return Promise.reject(new Error('\'hash\' must be a function that takes a password and returns Promise that resolves with a hashed password.'));
    }

    if (hook.data === undefined) {
      debug('hook.data is undefined. Skipping hashPassword hook.');
      return Promise.resolve(hook);
    }

    var data = void 0;

    // make sure we actually have password fields
    if (Array.isArray(hook.data)) {
      data = hook.data.filter(function (item) {
        return item.hasOwnProperty(field);
      });
    } else if (hook.data[field]) {
      data = hook.data;
    }

    // If the data doesn't have a password field
    // then don't attempt to hash it.
    if (data === undefined || Array.isArray(data) && !data.length) {
      debug('\'' + field + '\' field is missing. Skipping hashPassword hook.');
      return Promise.resolve(hook);
    }

    if (Array.isArray(data)) {
      debug('Hashing passwords.');

      return Promise.all(data.map(function (item) {
        return hashPw(item[field]).then(function (hashedPassword) {
          item[field] = hashedPassword;
          return item;
        });
      })).then(function (results) {
        hook.data = results;
        return Promise.resolve(hook);
      });
    }

    debug('Hashing password.');
    return hashPw(data[field]).then(function (hashedPassword) {
      hook.data[field] = hashedPassword;
      return Promise.resolve(hook);
    });
  };
}
module.exports = exports['default'];