'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _utils = require('./utils');

function _typeof(obj) { return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj; }

function getOrRemove(args) {
  return {
    id: args[0],
    params: args[1],
    callback: args[2]
  };
}

function updateOrPatch(args) {
  return {
    id: args[0],
    data: args[1],
    params: args[2],
    callback: args[3]
  };
}

var converters = {
  find: function find(args) {
    return {
      params: args[0],
      callback: args[1]
    };
  },
  create: function create(args) {
    return {
      data: args[0],
      params: args[1],
      callback: args[2]
    };
  },
  get: getOrRemove,
  remove: getOrRemove,
  update: updateOrPatch,
  patch: updateOrPatch
};

function hookObject(method, type, args) {
  var app = arguments.length <= 3 || arguments[3] === undefined ? {} : arguments[3];

  var hook = converters[method](args);

  hook.method = method;
  hook.type = type;

  if (typeof app === 'function') {
    hook.app = app;
  } else {
    _extends(hook, app);
  }

  return hook;
}

function defaultMakeArguments(hook) {
  var result = [];
  if (typeof hook.id !== 'undefined') {
    result.push(hook.id);
  }

  if (hook.data) {
    result.push(hook.data);
  }

  result.push(hook.params || {});
  result.push(hook.callback);

  return result;
}

function makeArguments(hook) {
  if (hook.method === 'find') {
    return [hook.params, hook.callback];
  }

  if (hook.method === 'get' || hook.method === 'remove') {
    return [hook.id, hook.params, hook.callback];
  }

  if (hook.method === 'update' || hook.method === 'patch') {
    return [hook.id, hook.data, hook.params, hook.callback];
  }

  if (hook.method === 'create') {
    return [hook.data, hook.params, hook.callback];
  }

  return defaultMakeArguments(hook);
}

function convertHookData(obj) {
  var hook = {};

  if (Array.isArray(obj)) {
    hook = { all: obj };
  } else if ((typeof obj === 'undefined' ? 'undefined' : _typeof(obj)) !== 'object') {
    hook = { all: [obj] };
  } else {
    (0, _utils.each)(obj, function (value, key) {
      hook[key] = !Array.isArray(value) ? [value] : value;
    });
  }

  return hook;
}

exports.default = {
  hookObject: hookObject,
  hook: hookObject,
  converters: converters,
  defaultMakeArguments: defaultMakeArguments,
  makeArguments: makeArguments,
  convertHookData: convertHookData
};
module.exports = exports['default'];