// Compiled by ClojureScript 1.9.542 {}
goog.provide('hoplon.bidi');
goog.require('cljs.core');
goog.require('cuerdas.core');
goog.require('bidi.bidi');
goog.require('schema.core');
goog.require('bidi.schema');
goog.require('javelin.core');
goog.require('hoplon.jquery');
goog.require('hoplon.core');
hoplon.bidi.match_route = bidi.bidi.match_route;
/**
 * Default route cell, without prefix.
 */
hoplon.bidi._STAR_route_STAR_ = hoplon.core.route_cell.call(null,"");
/**
 * Takes `routes` and a (route-cell).
 * Returns formula cell containing current matching handler.
 */
hoplon.bidi.wrap_route = (function hoplon$bidi$wrap_route(routes,routec){
return javelin.core.formula.call(null,(function (G__12443,G__12442,G__12441,G__12444){
return new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__12441.call(null,G__12442,G__12443.call(null,G__12444,"#")));
})).call(null,cuerdas.core.strip_prefix,routes,bidi.bidi.match_route,routec);
});
/**
 * Takes `routes` and a (route-cell).
 * Returns formula cell containing current route params.
 */
hoplon.bidi.wrap_route_params = (function hoplon$bidi$wrap_route_params(routes,routec){
return javelin.core.formula.call(null,(function (G__12451,G__12450,G__12449,G__12452){
return new cljs.core.Keyword(null,"route-params","route-params",2111411055).cljs$core$IFn$_invoke$arity$1(G__12449.call(null,G__12450,G__12451.call(null,G__12452,"#")));
})).call(null,cuerdas.core.strip_prefix,routes,bidi.bidi.match_route,routec);
});
/**
 * Takes `routes`, returns a formula cell with the current route handler.
 */
hoplon.bidi.route = (function hoplon$bidi$route(routes){
return hoplon.bidi.wrap_route.call(null,routes,hoplon.bidi._STAR_route_STAR_);
});
/**
 * Takes `routes`, returns a formula cell with the current route params.
 */
hoplon.bidi.route_params = (function hoplon$bidi$route_params(routes){
return hoplon.bidi.wrap_route_params.call(null,routes,hoplon.bidi._STAR_route_STAR_);
});
/**
 * Takes `routes` and `handler`, returns formula cell.
 * Formula cell is true if `route` is currently active.
 */
hoplon.bidi.route_QMARK_ = (function hoplon$bidi$route_QMARK_(routes,handler){
var route = hoplon.bidi.route.call(null,routes);
return javelin.core.formula.call(null,((function (route){
return (function (G__12458,G__12456,G__12457){
return G__12456.call(null,G__12457,G__12458);
});})(route))
).call(null,handler,cljs.core._EQ_,route);
});
/**
 * Generate a valid route. (includes '#' character)
 */
hoplon.bidi.mkroute = (function hoplon$bidi$mkroute(var_args){
var args__8304__auto__ = [];
var len__8297__auto___12461 = arguments.length;
var i__8298__auto___12462 = (0);
while(true){
if((i__8298__auto___12462 < len__8297__auto___12461)){
args__8304__auto__.push((arguments[i__8298__auto___12462]));

var G__12463 = (i__8298__auto___12462 + (1));
i__8298__auto___12462 = G__12463;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((1) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((1)),(0),null)):null);
return hoplon.bidi.mkroute.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8305__auto__);
});

hoplon.bidi.mkroute.cljs$core$IFn$_invoke$arity$variadic = (function (routes,routeopts){
return cuerdas.core.join.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#",cljs.core.apply.call(null,bidi.bidi.path_for,routes,routeopts)], null));
});

hoplon.bidi.mkroute.cljs$lang$maxFixedArity = (1);

hoplon.bidi.mkroute.cljs$lang$applyTo = (function (seq12459){
var G__12460 = cljs.core.first.call(null,seq12459);
var seq12459__$1 = cljs.core.next.call(null,seq12459);
return hoplon.bidi.mkroute.cljs$core$IFn$_invoke$arity$variadic(G__12460,seq12459__$1);
});

/**
 * Change URL hash, does not reload the page.
 */
hoplon.bidi.route_BANG_ = (function hoplon$bidi$route_BANG_(var_args){
var args__8304__auto__ = [];
var len__8297__auto___12466 = arguments.length;
var i__8298__auto___12467 = (0);
while(true){
if((i__8298__auto___12467 < len__8297__auto___12466)){
args__8304__auto__.push((arguments[i__8298__auto___12467]));

var G__12468 = (i__8298__auto___12467 + (1));
i__8298__auto___12467 = G__12468;
continue;
} else {
}
break;
}

var argseq__8305__auto__ = ((((1) < args__8304__auto__.length))?(new cljs.core.IndexedSeq(args__8304__auto__.slice((1)),(0),null)):null);
return hoplon.bidi.route_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8305__auto__);
});

hoplon.bidi.route_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (routes,routeopts){
return (window["location"]["hash"] = cljs.core.apply.call(null,hoplon.bidi.mkroute,routes,routeopts));
});

hoplon.bidi.route_BANG_.cljs$lang$maxFixedArity = (1);

hoplon.bidi.route_BANG_.cljs$lang$applyTo = (function (seq12464){
var G__12465 = cljs.core.first.call(null,seq12464);
var seq12464__$1 = cljs.core.next.call(null,seq12464);
return hoplon.bidi.route_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12465,seq12464__$1);
});

/**
 * Validate `routes` against bidi schema.
 */
hoplon.bidi.validate = (function hoplon$bidi$validate(routes){
return schema.core.validate.call(null,bidi.schema.RoutePair,routes);
});

//# sourceMappingURL=bidi.js.map