'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = init;

var _debug = require('debug');

var _debug2 = _interopRequireDefault(_debug);

var _lodash = require('lodash.merge');

var _lodash2 = _interopRequireDefault(_lodash);

var _lodash3 = require('lodash.omit');

var _lodash4 = _interopRequireDefault(_lodash3);

var _lodash5 = require('lodash.pick');

var _lodash6 = _interopRequireDefault(_lodash5);

var _hooks = require('./hooks');

var _hooks2 = _interopRequireDefault(_hooks);

var _verifier = require('./verifier');

var _verifier2 = _interopRequireDefault(_verifier);

var _passportLocal = require('passport-local');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var debug = (0, _debug2.default)('feathers-authentication-local');
var defaults = {
  name: 'local',
  usernameField: 'email',
  passwordField: 'password'
};

var KEYS = ['entity', 'service', 'passReqToCallback', 'session'];

function init() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  return function localAuth() {
    var app = this;
    var _super = app.setup;

    if (!app.passport) {
      throw new Error('Can not find app.passport. Did you initialize feathers-authentication before feathers-authentication-local?');
    }

    var name = options.name || defaults.name;
    var authOptions = app.get('auth') || {};
    var localOptions = authOptions[name] || {};

    // NOTE (EK): Pull from global auth config to support legacy auth for an easier transition.
    var localSettings = (0, _lodash2.default)({}, defaults, (0, _lodash6.default)(authOptions, KEYS), localOptions, (0, _lodash4.default)(options, ['Verifier']));
    var Verifier = _verifier2.default;

    if (options.Verifier) {
      Verifier = options.Verifier;
    }

    app.setup = function () {
      var result = _super.apply(this, arguments);
      var verifier = new Verifier(app, localSettings);

      if (!verifier.verify) {
        throw new Error('Your verifier must implement a \'verify\' function. It should have the same signature as a local passport verify callback.');
      }

      // Register 'local' strategy with passport
      debug('Registering local authentication strategy with options:', localSettings);
      app.passport.use(localSettings.name, new _passportLocal.Strategy(localSettings, verifier.verify.bind(verifier)));
      app.passport.options(localSettings.name, localSettings);

      return result;
    };
  };
}

// Exposed Modules
Object.assign(init, {
  defaults: defaults,
  hooks: _hooks2.default,
  Verifier: _verifier2.default
});
module.exports = exports['default'];