'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _uberproto = require('uberproto');

var _uberproto2 = _interopRequireDefault(_uberproto);

var _feathersCommons = require('feathers-commons');

var _commons = require('./commons');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function isPromise(result) {
  return typeof result !== 'undefined' && typeof result.then === 'function';
}

function hookMixin(service) {
  if (typeof service.hooks === 'function') {
    return;
  }

  var app = this;
  var methods = app.methods;
  var old = {
    before: service.before,
    after: service.after
  };
  var mixin = (0, _commons.baseMixin)(methods, {
    before: function before(_before) {
      return this.hooks({ before: _before });
    },
    after: function after(_after) {
      return this.hooks({ after: _after });
    }
  });

  (0, _commons.addHookTypes)(service);

  methods.forEach(function (method) {
    if (typeof service[method] !== 'function') {
      return;
    }

    mixin[method] = function () {
      var _this = this;

      var service = this;
      // A reference to the original method
      var _super = this._super.bind(this);
      // Additional data to add to the hook object
      var hookData = {
        app: app,
        service: service,
        get path() {
          return Object.keys(app.services).find(function (path) {
            return app.services[path] === service;
          });
        }
      };
      // Create the hook object that gets passed through
      var hookObject = _feathersCommons.hooks.hookObject(method, 'before', arguments, hookData);
      // Get all hooks
      var hooks = {
        // For before hooks the app hooks will run first
        before: (0, _commons.getHooks)(app, this, 'before', method),
        // For after and error hooks the app hooks will run last
        after: (0, _commons.getHooks)(app, this, 'after', method, true),
        error: (0, _commons.getHooks)(app, this, 'error', method, true)
      };

      // Process all before hooks
      return _commons.processHooks.call(this, hooks.before, hookObject)
      // Use the hook object to call the original method
      .then(function (hookObject) {
        if (typeof hookObject.result !== 'undefined') {
          return Promise.resolve(hookObject);
        }

        return new Promise(function (resolve, reject) {
          var args = _feathersCommons.hooks.makeArguments(hookObject);
          // The method may not be normalized yet so we have to handle both
          // ways, either by callback or by Promise
          var callback = function callback(error, result) {
            if (error) {
              reject(error);
            } else {
              hookObject.result = result;
              resolve(hookObject);
            }
          };

          // We replace the callback with resolving the promise
          args.splice(args.length - 1, 1, callback);

          var result = _super.apply(undefined, _toConsumableArray(args));

          if (isPromise(result)) {
            result.then(function (data) {
              return callback(null, data);
            }, callback);
          }
        });
      })
      // Make a copy of hookObject from `before` hooks and update type
      .then(function (hookObject) {
        return Object.assign({}, hookObject, { type: 'after' });
      })
      // Run through all `after` hooks
      .then(_commons.processHooks.bind(this, hooks.after))
      // Finally, return the result
      .then(function (hookObject) {
        return hookObject.result;
      })
      // Handle errors
      .catch(function (error) {
        var errorHook = Object.assign({}, error.hook || hookObject, {
          type: 'error',
          original: error.hook,
          error: error
        });

        return _commons.processHooks.call(_this, hooks.error, errorHook).then(function (hook) {
          return Promise.reject(hook.error);
        });
      });
    };
  });

  service.mixin(mixin);

  // Before hooks that were registered in the service
  if (old.before) {
    service.before(old.before);
  }

  // After hooks that were registered in the service
  if (old.after) {
    service.after(old.after);
  }
}

function configure() {
  return function () {
    var app = this;

    (0, _commons.addHookTypes)(app);

    _uberproto2.default.mixin((0, _commons.baseMixin)(app.methods), app);

    this.mixins.unshift(hookMixin);
  };
}

exports.default = configure;
module.exports = exports['default'];