(ns meta.ui
  (:require [hoplon.core :as h]
            [meta.ui.mdc :as mdc]
            [meta.ui.uikit :as uikit]))

(defn app [& opts]
  (let [style (:style opts :uikit)]
    (case style
      :mdc (apply mdc/app opts)
      :uikit (apply uikit/app opts))))

;;; RAW DOM Elements ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def html h/html)
(def head h/head)
(def body h/body)

(def a              h/a)
(def abbr           h/abbr)
(def address        h/address)
(def area           h/area)
(def article        h/article)
(def aside          h/aside)
(def audio          h/audio)
(def b              h/b)
(def base           h/base)
(def bdi            h/bdi)
(def bdo            h/bdo)
(def blockquote     h/blockquote)
(def br             h/br)
(def button         h/button)
(def canvas         h/canvas)
(def caption        h/caption)
(def cite           h/cite)
(def code           h/code)
(def col            h/col)
(def colgroup       h/colgroup)
(def data           h/data)
(def datalist       h/datalist)
(def dd             h/dd)
(def del            h/del)
(def details        h/details)
(def dfn            h/dfn)
(def dialog         h/dialog)
(def div            h/div)
(def dl             h/dl)
(def dt             h/dt)
(def em             h/em)
(def embed          h/embed)
(def fieldset       h/fieldset)
(def figcaption     h/figcaption)
(def figure         h/figure)
(def footer         h/footer)
(def form           h/form)
(def h1             h/h1)
(def h2             h/h2)
(def h3             h/h3)
(def h4             h/h4)
(def h5             h/h5)
(def h6             h/h6)
(def header         h/header)
(def hgroup         h/hgroup)
(def hr             h/hr)
(def i              h/i)
(def iframe         h/iframe)
(def img            h/img)
(def input          h/input)
(def ins            h/ins)
(def kbd            h/kbd)
(def keygen         h/keygen)
(def label          h/label)
(def legend         h/legend)
(def li             h/li)
(def link           h/link)
(def main           h/main)
(def html-map       h/html-map)
(def mark           h/mark)
(def menu           h/menu)
(def menuitem       h/menuitem)
(def html-meta      h/html-meta)
(def meter          h/meter)
(def multicol       h/multicol)
(def nav            h/nav)
(def noframes       h/noframes)
(def noscript       h/noscript)
(def html-object    h/html-object)
(def ol             h/ol)
(def optgroup       h/optgroup)
(def option         h/option)
(def output         h/output)
(def p              h/p)
(def param          h/param)
(def picture        h/picture)
(def pre            h/pre)
(def progress       h/progress)
(def q              h/q)
(def rp             h/rp)
(def rt             h/rt)
(def rtc            h/rtc)
(def ruby           h/ruby)
(def s              h/s)
(def samp           h/samp)
(def script         h/script)
(def section        h/section)
(def select         h/select)
(def shadow         h/shadow)
(def small          h/small)
(def source         h/source)
(def span           h/span)
(def strong         h/strong)
(def style          h/style)
(def sub            h/sub)
(def summary        h/summary)
(def sup            h/sup)
(def table          h/table)
(def tbody          h/tbody)
(def td             h/td)
(def template       h/template)
(def textarea       h/textarea)
(def tfoot          h/tfoot)
(def th             h/th)
(def thead          h/thead)
(def html-time      h/html-time)
(def title          (make-elem-ctor "title"))
(def tr             (make-elem-ctor "tr"))
(def track          (make-elem-ctor "track"))
(def u              (make-elem-ctor "u"))
(def ul             (make-elem-ctor "ul"))
(def html-var       (make-elem-ctor "var"))
(def video          (make-elem-ctor "video"))
(def wbr            (make-elem-ctor "wbr"))

(def spliced        vector)
(def $text          #(.createTextNode js/document %))
(def $comment       #(.createComment js/document %))

(def <!--           $comment)
(def -->            ::-->)
