(ns meta.boot.init
  (:require [boot.core :as boot]
            [boot.util :as util]
            [meta.boot.util :as mutil]
            [clojure.java.io :as io]))

(defn initialize-env
  "Load project environment."
  [file]
  (when-let [env (mutil/read-file file)]
    (util/info "Loading project environment...\n")
    (doseq [[key val] env]
      (if (mutil/verify-env key val)
        (boot/merge-env! key val)
        (util/fail "• %s validation failed...: %s\n" (name key) val)))))

(defn initialize-tasks
  "Load project tasks."
  [file]
  (when-let [tasks (mutil/read-file file)]
    (util/info "Loading project tasks...\n")
    (doseq [[n _ r :as req] (remove nil? tasks)]
      (cond (keyword? r) (util/info "• %s from %s\n" r n)
            (coll? r)  (doseq [t r] (util/info "• %s from %s\n" t n))
            :else        (util/fail "Failed to Load Tasks...: %s \n" req))
      (require req))))

(defn initialize-impl
  ([] (initialize-impl {}))
  ([opts]
   (let [name     (:project opts 'app)
         env      (:env opts "./env.boot")
         settings (:settings opts [:dependencies])
         tasks    (:tasks opts "./tasks.boot")
         msg      (if (and name (not= 'app name)) (str name) "Welcome!")]
     (boot/set-env!
       :meta {:project name})
     ;; convert from task; (welcome :message msg)
     (initialize-env env)
     (initialize-tasks tasks))))
