(ns uikit-hl.width
  (:require [uikit-hl.core :as core :include-macros true]
            [hoplon.core :as hl]))

(core/defwidth "width" "1-1")
(core/defwidth "width" "1-2")
(core/defwidth "width" "1-3")
(core/defwidth "width" "1-4")
(core/defwidth "width" "1-5")
(core/defwidth "width" "1-6")

(core/defwidth "width" "2-3")
(core/defwidth "width" "2-4")
(core/defwidth "width" "2-5")
(core/defwidth "width" "2-6")

(core/defwidth "width" "3-4")
(core/defwidth "width" "3-5")
(core/defwidth "width" "3-6")

(core/defwidth "width" "4-5")
(core/defwidth "width" "4-6")

(core/defwidth "width" "5-6")

(core/defwidth "width" "auto")
(core/defwidth "width" "expand")

(core/defwidth "child-width" "1-6")
(core/defwidth "child-width" "2-6")
(core/defwidth "child-width" "3-6")
(core/defwidth "child-width" "4-6")
(core/defwidth "child-width" "5-6")
(core/defwidth "child-width" "2-6")

(core/defwidth "child-width" "auto")
(core/defwidth "child-width" "expand")

(core/defwidth "width" "small" "%s-%s")

(def ^:dynamic *width-small* nil)
(def ^:dynamic *width-medium* nil)
(def ^:dynamic *width-large* nil)
(def ^:dynamic *width-xlarge* nil)
(def ^:dynamic *width-xxlarge* nil)

(defmethod hl/do! :uk-animation
  [elem _ v]
  (->> v
    (merge {:uk-animation-fade *fade*

            :uk-animation-scale-up   *scale-up*
            :uk-animation-scale-down *scale-down*

            :uk-animation-slide-top    *slide-top*
            :uk-animation-slide-bottom *slide-bottom*
            :uk-animation-slide-left   *slide-left*
            :uk-animation-slide-right  *slide-right*

            :uk-animation-slide-top-small    *slide-top-small*
            :uk-animation-slide-bottom-small *slide-bottom-small*
            :uk-animation-slide-left-small   *slide-left-small*
            :uk-animation-slide-right-small  *slide-right-small*

            :uk-animation-slide-top-medium    *slide-top-medium*
            :uk-animation-slide-bottom-medium *slide-bottom-medium*
            :uk-animation-slide-left-medium   *slide-left-medium*
            :uk-animation-slide-right-medium  *slide-right-medium*

            :uk-animation-kenburns *kenburns*

            :uk-animation-shake *shake*})
    (hl/do! elem :class )))

(defmethod hl/do! :animation-fade
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-fade v}))

(defmethod hl/do! :animation-scale-up
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-scale-up v}))

(defmethod hl/do! :animation-scale-down
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-scale-down v}))

(defmethod hl/do! :animation-slide-top
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-top v}))

(defmethod hl/do! :animation-slide-bottom
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-bottom v}))

(defmethod hl/do! :animation-slide-left
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-left v}))

(defmethod hl/do! :animation-slide-right
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-right v}))

(defmethod hl/do! :animation-slide-top-small
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-top-small v}))

(defmethod hl/do! :animation-slide-bottom-small
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-bottom-small v}))

(defmethod hl/do! :animation-slide-left-small
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-left-small v}))

(defmethod hl/do! :animation-slide-right-small
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-right-small v}))

(defmethod hl/do! :animation-slide-top-medium
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-top-medium v}))

(defmethod hl/do! :animation-slide-bottom-medium
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-bottom-medium v}))

(defmethod hl/do! :animation-slide-left-medium
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-left-medium v}))

(defmethod hl/do! :animation-slide-right-medium
  [elem _ v]
  (hl/do! elem :uk-animation {:uk-animation-slide-right-medium v}))
