(ns uikit-hl.width
  (:require [uikit-hl.core :as core :include-macros true]
            [hoplon.core :as hl]))

(core/defwidth "width" "1-1")
(core/defwidth "width" "1-2")
(core/defwidth "width" "1-3")
(core/defwidth "width" "1-4")
(core/defwidth "width" "1-5")
(core/defwidth "width" "1-6")

(core/defwidth "width" "2-3")
(core/defwidth "width" "2-4")
(core/defwidth "width" "2-5")
(core/defwidth "width" "2-6")

(core/defwidth "width" "3-4")
(core/defwidth "width" "3-5")
(core/defwidth "width" "3-6")

(core/defwidth "width" "4-5")
(core/defwidth "width" "4-6")

(core/defwidth "width" "5-6")

(core/defwidth "width" "auto")
(core/defwidth "width" "expand")

(core/defwidth "child-width" "1-6")
(core/defwidth "child-width" "2-6")
(core/defwidth "child-width" "3-6")
(core/defwidth "child-width" "4-6")
(core/defwidth "child-width" "5-6")

(core/defwidth "child-width" "auto")
(core/defwidth "child-width" "expand")

(core/defwidth "width" "small" "%s-%s")
(core/defwidth "width" "medium" "%s-%s")
(core/defwidth "width" "large" "%s-%s")
(core/defwidth "width" "xlarge" "%s-%s")
(core/defwidth "width" "xxlarge" "%s-%s")

(defmethod hl/do! :uk-width
  [elem _ v]
  (->> v
    (merge {:uk-width-1-1               *width-1-1*
            (keyword "uk-width-1-1@s")  *width-1-1-s*
            (keyword "uk-width-1-1@m")  *width-1-1-m*
            (keyword "uk-width-1-1@l")  *width-1-1-l*
            (keyword "uk-width-1-1@xl") *width-1-1-xl*

            :uk-width-1-2               *width-1-2*
            (keyword "uk-width-1-2@s")  *width-1-2-s*
            (keyword "uk-width-1-2@m")  *width-1-2-m*
            (keyword "uk-width-1-2@l")  *width-1-2-l*
            (keyword "uk-width-1-2@xl") *width-1-2-xl*

            :uk-width-1-3               *width-1-3*
            (keyword "uk-width-1-3@s")  *width-1-3-s*
            (keyword "uk-width-1-3@m")  *width-1-3-m*
            (keyword "uk-width-1-3@l")  *width-1-3-l*
            (keyword "uk-width-1-3@xl") *width-1-3-xl*

            :uk-width-1-4               *width-1-4*
            (keyword "uk-width-1-4@s")  *width-1-4-s*
            (keyword "uk-width-1-4@m")  *width-1-4-m*
            (keyword "uk-width-1-4@l")  *width-1-4-l*
            (keyword "uk-width-1-4@xl") *width-1-4-xl*

            :uk-width-1-5               *width-1-5*
            (keyword "uk-width-1-5@s")  *width-1-5-s*
            (keyword "uk-width-1-5@m")  *width-1-5-m*
            (keyword "uk-width-1-5@l")  *width-1-5-l*
            (keyword "uk-width-1-5@xl") *width-1-5-xl*

            :uk-width-1-6               *width-1-6*
            (keyword "uk-width-1-6@s")  *width-1-6-s*
            (keyword "uk-width-1-6@m")  *width-1-6-m*
            (keyword "uk-width-1-6@l")  *width-1-6-l*
            (keyword "uk-width-1-6@xl") *width-1-6-xl*

            :uk-width-2-3               *width-2-3*
            (keyword "uk-width-2-3@s")  *width-2-3-s*
            (keyword "uk-width-2-3@m")  *width-2-3-m*
            (keyword "uk-width-2-3@l")  *width-2-3-l*
            (keyword "uk-width-2-3@xl") *width-2-3-xl*

            :uk-width-2-4               *width-2-4*
            (keyword "uk-width-2-4@s")  *width-2-4-s*
            (keyword "uk-width-2-4@m")  *width-2-4-m*
            (keyword "uk-width-2-4@l")  *width-2-4-l*
            (keyword "uk-width-2-4@xl") *width-2-4-xl*

            :uk-width-2-5               *width-2-5*
            (keyword "uk-width-2-5@s")  *width-2-5-s*
            (keyword "uk-width-2-5@m")  *width-2-5-m*
            (keyword "uk-width-2-5@l")  *width-2-5-l*
            (keyword "uk-width-2-5@xl") *width-2-5-xl*

            :uk-width-2-6               *width-2-6*
            (keyword "uk-width-2-6@s")  *width-2-6-s*
            (keyword "uk-width-2-6@m")  *width-2-6-m*
            (keyword "uk-width-2-6@l")  *width-2-6-l*
            (keyword "uk-width-2-6@xl") *width-2-6-xl*

            :uk-width-3-4               *width-3-4*
            (keyword "uk-width-3-4@s")  *width-3-4-s*
            (keyword "uk-width-3-4@m")  *width-3-4-m*
            (keyword "uk-width-3-4@l")  *width-3-4-l*
            (keyword "uk-width-3-4@xl") *width-3-4-xl*

            :uk-width-3-5               *width-3-5*
            (keyword "uk-width-3-5@s")  *width-3-5-s*
            (keyword "uk-width-3-5@m")  *width-3-5-m*
            (keyword "uk-width-3-5@l")  *width-3-5-l*
            (keyword "uk-width-3-5@xl") *width-3-5-xl*

            :uk-width-3-6               *width-3-6*
            (keyword "uk-width-3-6@s")  *width-3-6-s*
            (keyword "uk-width-3-6@m")  *width-3-6-m*
            (keyword "uk-width-3-6@l")  *width-3-6-l*
            (keyword "uk-width-3-6@xl") *width-3-6-xl*

            :uk-width-4-5               *width-4-5*
            (keyword "uk-width-4-5@s")  *width-4-5-s*
            (keyword "uk-width-4-5@m")  *width-4-5-m*
            (keyword "uk-width-4-5@l")  *width-4-5-l*
            (keyword "uk-width-4-5@xl") *width-4-5-xl*

            :uk-width-4-6               *width-4-6*
            (keyword "uk-width-4-6@s")  *width-4-6-s*
            (keyword "uk-width-4-6@m")  *width-4-6-m*
            (keyword "uk-width-4-6@l")  *width-4-6-l*
            (keyword "uk-width-4-6@xl") *width-4-6-xl*

            :uk-width-5-6               *width-5-6*
            (keyword "uk-width-5-6@s")  *width-5-6-s*
            (keyword "uk-width-5-6@m")  *width-5-6-m*
            (keyword "uk-width-5-6@l")  *width-5-6-l*
            (keyword "uk-width-5-6@xl") *width-5-6-xl*

            :uk-width-auto               *width-auto*
            (keyword "uk-width-auto@s")  *width-auto-s*
            (keyword "uk-width-auto@m")  *width-auto-m*
            (keyword "uk-width-auto@l")  *width-auto-l*
            (keyword "uk-width-auto@xl") *width-auto-xl*

            :uk-width-expand               *width-expand*
            (keyword "uk-width-expand@s")  *width-expand-s*
            (keyword "uk-width-expand@m")  *width-expand-m*
            (keyword "uk-width-expand@l")  *width-expand-l*
            (keyword "uk-width-expand@xl") *width-expand-xl*
        })
    (hl/do! elem :class )))

(defmethod hl/do! :uk-child-width
  [elem _ v]
  (->> v
    (merge {:uk-child-width-1-1               *child-width-1-1*
            (keyword "uk-child-width-1-1@s")  *child-width-1-1-s*
            (keyword "uk-child-width-1-1@m")  *child-width-1-1-m*
            (keyword "uk-child-width-1-1@l")  *child-width-1-1-l*
            (keyword "uk-child-width-1-1@xl") *child-width-1-1-xl*

            :uk-child-width-1-2               *child-width-1-2*
            (keyword "uk-child-width-1-2@s")  *child-width-1-2-s*
            (keyword "uk-child-width-1-2@m")  *child-width-1-2-m*
            (keyword "uk-child-width-1-2@l")  *child-width-1-2-l*
            (keyword "uk-child-width-1-2@xl") *child-width-1-2-xl*

            :uk-child-width-1-3               *child-width-1-3*
            (keyword "uk-child-width-1-3@s")  *child-width-1-3-s*
            (keyword "uk-child-width-1-3@m")  *child-width-1-3-m*
            (keyword "uk-child-width-1-3@l")  *child-width-1-3-l*
            (keyword "uk-child-width-1-3@xl") *child-width-1-3-xl*

            :uk-child-width-1-4               *child-width-1-4*
            (keyword "uk-child-width-1-4@s")  *child-width-1-4-s*
            (keyword "uk-child-width-1-4@m")  *child-width-1-4-m*
            (keyword "uk-child-width-1-4@l")  *child-width-1-4-l*
            (keyword "uk-child-width-1-4@xl") *child-width-1-4-xl*

            :uk-child-width-1-5               *child-width-1-5*
            (keyword "uk-child-width-1-5@s")  *child-width-1-5-s*
            (keyword "uk-child-width-1-5@m")  *child-width-1-5-m*
            (keyword "uk-child-width-1-5@l")  *child-width-1-5-l*
            (keyword "uk-child-width-1-5@xl") *child-width-1-5-xl*

            :uk-child-width-1-6               *child-width-1-6*
            (keyword "uk-child-width-1-6@s")  *child-width-1-6-s*
            (keyword "uk-child-width-1-6@m")  *child-width-1-6-m*
            (keyword "uk-child-width-1-6@l")  *child-width-1-6-l*
            (keyword "uk-child-width-1-6@xl") *child-width-1-6-xl*

            :uk-child-width-auto               *child-width-auto*
            (keyword "uk-child-width-auto@s")  *child-width-auto-s*
            (keyword "uk-child-width-auto@m")  *child-width-auto-m*
            (keyword "uk-child-width-auto@l")  *child-width-auto-l*
            (keyword "uk-child-width-auto@xl") *child-width-auto-xl*

            :uk-child-width-expand               *child-width-expand*
            (keyword "uk-child-width-expand@s")  *child-width-expand-s*
            (keyword "uk-child-width-expand@m")  *child-width-expand-m*
            (keyword "uk-child-width-expand@l")  *child-width-expand-l*
            (keyword "uk-child-width-expand@xl") *child-width-expand-xl*})
    (hl/do! elem :class )))

(core/defwidthmethod "width" "1-1")
(core/defwidthmethod "width" "1-2")
(core/defwidthmethod "width" "1-3")
(core/defwidthmethod "width" "1-4")
(core/defwidthmethod "width" "1-5")
(core/defwidthmethod "width" "1-6")

(core/defwidthmethod "width" "2-3")
(core/defwidthmethod "width" "2-4")
(core/defwidthmethod "width" "2-5")
(core/defwidthmethod "width" "2-6")

(core/defwidthmethod "width" "3-4")
(core/defwidthmethod "width" "3-5")
(core/defwidthmethod "width" "3-6")

(core/defwidthmethod "width" "4-5")
(core/defwidthmethod "width" "4-6")

(core/defwidthmethod "width" "5-6")

(core/defwidthmethod "width" "auto")
(core/defwidthmethod "width" "expand")

(core/defwidthmethod "child-width" "1-6")
(core/defwidthmethod "child-width" "2-6")
(core/defwidthmethod "child-width" "3-6")
(core/defwidthmethod "child-width" "4-6")
(core/defwidthmethod "child-width" "5-6")
(core/defwidthmethod "child-width" "2-6")

(core/defwidthmethod "child-width" "auto")
(core/defwidthmethod "child-width" "expand")

(core/defwidthmethod "width" "small" "%s-%s")
(core/defwidthmethod "width" "medium" "%s-%s")
(core/defwidthmethod "width" "large" "%s-%s")
(core/defwidthmethod "width" "xlarge" "%s-%s")
(core/defwidthmethod "width" "xxlarge" "%s-%s")
