(ns uikit-hl.flex
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-flex* "")
(def ^:dynamic *title* "")

(defmethod hl/do! :uk-flex
  [elem _ v]
  (.flex js/UIkit elem (clj->js v)))

(hl/defelem flex [attr kids]
  (let [flex (:uk-flex attr *uk-flex*)
        attr      (assoc attr :uk-flex flex)]
    (hl/ul attr kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-flex-title] (hl/text "~{title}"))
      (hl/div :class [:uk-flex-content] kids))))
