(ns uikit-hl.flex
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-flex*        true)
(def ^:dynamic *uk-flex-inline* nil)

(def ^:dynamic *uk-flex-left*    nil)
(def ^:dynamic *uk-flex-left-s*  nil)
(def ^:dynamic *uk-flex-left-m*  nil)
(def ^:dynamic *uk-flex-left-l*  nil)
(def ^:dynamic *uk-flex-left-xl* nil)

(def ^:dynamic *uk-flex-center*    nil)
(def ^:dynamic *uk-flex-center-s*  nil)
(def ^:dynamic *uk-flex-center-m*  nil)
(def ^:dynamic *uk-flex-center-l*  nil)
(def ^:dynamic *uk-flex-center-xl* nil)

(def ^:dynamic *uk-flex-right*    nil)
(def ^:dynamic *uk-flex-right-s*  nil)
(def ^:dynamic *uk-flex-right-m*  nil)
(def ^:dynamic *uk-flex-right-l*  nil)
(def ^:dynamic *uk-flex-right-xl* nil)

(def ^:dynamic *uk-flex-between*    nil)
(def ^:dynamic *uk-flex-between-s*  nil)
(def ^:dynamic *uk-flex-between-m*  nil)
(def ^:dynamic *uk-flex-between-l*  nil)
(def ^:dynamic *uk-flex-between-xl* nil)

(def ^:dynamic *uk-flex-around*  nil)
(def ^:dynamic *uk-flex-around-s*  nil)
(def ^:dynamic *uk-flex-around-m*  nil)
(def ^:dynamic *uk-flex-around-l*  nil)
(def ^:dynamic *uk-flex-around-xl* nil)

(defmethod hl/do! :uk-flex
  [elem _ v]
  (->> v
    (merge {:uk-flex        *uk-flex*
            :uk-flex-inline *uk-flex-inline*

            :uk-flex-left               *uk-flex-left*
            (keyword "uk-flex-left@s")  *uk-flex-left-s*
            (keyword "uk-flex-left@m")  *uk-flex-left-m*
            (keyword "uk-flex-left@l")  *uk-flex-left-l*
            (keyword "uk-flex-left@xl") *uk-flex-left-xl*})
    (hl/do! elem :class )))
