(ns uikit-hl.padding
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *padding* nil)

(def ^:dynamic *padding-small*  nil)
(def ^:dynamic *padding-large*  nil)
(def ^:dynamic *padding-xlarge* nil)

(def ^:dynamic *padding-remove*           nil)
(def ^:dynamic *padding-remove-top*       nil)
(def ^:dynamic *padding-remove-bottom*    nil)
(def ^:dynamic *padding-remove-left*      nil)
(def ^:dynamic *padding-remove-right*     nil)
(def ^:dynamic *padding-remove-vertical*  nil)
(def ^:dynamic *padding-remove-horizontal*  nil)

(defmethod hl/do! :uk-padding
  [elem _ v]
  (->> v
    (merge {:uk-padding        *padding*
            :uk-padding-small  *padding-top*
            :uk-padding-large  *padding-bottom*
            :uk-padding-xlarge *padding-left*

            :uk-padding-remove            *padding-remove*
            :uk-padding-remove-top        *padding-remove-top*
            :uk-padding-remove-bottom     *padding-remove-bottom*
            :uk-padding-remove-left       *padding-remove-left*
            :uk-padding-remove-right      *padding-remove-right*
            :uk-padding-remove-vertical   *padding-remove-vertical*
            :uk-padding-remove-horizontal *padding-remove-horizontal*
            })
    (hl/do! elem :class )))

(defmethod hoplon.core/do! :padding-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-top v}))

(defmethod hoplon.core/do! :padding-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-bottom v}))

(defmethod hoplon.core/do! :padding-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-left v}))

(defmethod hoplon.core/do! :padding-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-right v}))

(defmethod hoplon.core/do! :padding-small-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-small-top v}))

(defmethod hoplon.core/do! :padding-small-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-small-bottom v}))

(defmethod hoplon.core/do! :padding-small-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-small-left v}))

(defmethod hoplon.core/do! :padding-small-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-small-right v}))

(defmethod hoplon.core/do! :padding-medium-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-medium-top v}))

(defmethod hoplon.core/do! :padding-medium-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-medium-bottom v}))

(defmethod hoplon.core/do! :padding-medium-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-medium-left v}))

(defmethod hoplon.core/do! :padding-medium-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-medium-right v}))

(defmethod hoplon.core/do! :padding-large-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-large-top v}))

(defmethod hoplon.core/do! :padding-large-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-large-bottom v}))

(defmethod hoplon.core/do! :padding-large-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-large-left v}))

(defmethod hoplon.core/do! :padding-large-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-large-right v}))

(defmethod hoplon.core/do! :padding-xlarge-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-xlarge-top v}))

(defmethod hoplon.core/do! :padding-xlarge-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-xlarge-bottom v}))

(defmethod hoplon.core/do! :padding-xlarge-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-xlarge-left v}))

(defmethod hoplon.core/do! :padding-xlarge-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-xlarge-right v}))

(defmethod hoplon.core/do! :padding-remove
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove v}))

(defmethod hoplon.core/do! :padding-remove-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-top v}))

(defmethod hoplon.core/do! :padding-remove-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-bottom v}))

(defmethod hoplon.core/do! :padding-remove-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-left v}))

(defmethod hoplon.core/do! :padding-remove-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-right v}))

(defmethod hoplon.core/do! :padding-remove-vertical
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-vertical v}))

(defmethod hoplon.core/do! :padding-remove-adjacent
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-remove-adjacent v}))

(defmethod hoplon.core/do! :padding-auto
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto v}))

(defmethod hoplon.core/do! :padding-auto-top
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto-top v}))

(defmethod hoplon.core/do! :padding-auto-bottom
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto-bottom v}))

(defmethod hoplon.core/do! :padding-auto-left
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto-left v}))

(defmethod hoplon.core/do! :padding-auto-right
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto-right v}))

(defmethod hoplon.core/do! :padding-auto-vertical
  [elem kw v]
  (hoplon.core/do! elem :uk-padding-class {:uk-padding-auto-vertical v}))
