(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(def ^:dynamic *invisible* nil)

(defmethod hl/do! :uk-visibility
  [elem _ v]
  (.visibility js/UIkit elem (clj->js v)))

(hl/defelem visibility [attr kids]
  (let [visibility (:uk-visibility attr *uk-visibility*)
        attr      (assoc attr :uk-visibility visibility)]
    (hl/ul attr kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-visibility-title] (hl/text "~{title}"))
      (hl/div :class [:uk-visibility-content] kids))))
